/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.queries;

import dev.gigaherz.util.gddl2.queries.QueryComponent;
import dev.gigaherz.util.gddl2.serialization.Formatter;
import dev.gigaherz.util.gddl2.structure.GddlElement;
import dev.gigaherz.util.gddl2.util.Utility;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class MapQueryComponent
extends QueryComponent {
    private final String name;

    public MapQueryComponent(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Stream<GddlElement<?>> filter(Stream<GddlElement<?>> input) {
        return input.filter(GddlElement::isMap).map(GddlElement::asMap).filter((? super T m) -> m.containsKey(this.name)).map(m -> m.get(this.name));
    }

    @Override
    public String toString(Formatter formatter) {
        String name = this.getName();
        if (formatter.getOptions().alwaysUseStringLiterals || !Utility.isValidIdentifier(name)) {
            name = Utility.escapeString(name);
        }
        return name;
    }

    @Override
    public QueryComponent copy() {
        return new MapQueryComponent(this.getName());
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.equalsImpl((MapQueryComponent)other);
    }

    public boolean equals(MapQueryComponent other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.equalsImpl(other);
    }

    private boolean equalsImpl(@NotNull MapQueryComponent other) {
        return Objects.equals(this.name, other.name);
    }

    @Override
    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

