/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.structure;

import dev.gigaherz.util.gddl2.queries.Query;
import dev.gigaherz.util.gddl2.serialization.Formatter;
import dev.gigaherz.util.gddl2.structure.GddlList;
import dev.gigaherz.util.gddl2.structure.GddlMap;
import dev.gigaherz.util.gddl2.structure.GddlReference;
import dev.gigaherz.util.gddl2.structure.GddlValue;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class GddlElement<T extends GddlElement<T>> {
    private GddlElement<?> parent;
    String whitespace = "";
    String comment = "";

    public final boolean hasWhitespace() {
        return this.whitespace.length() > 0;
    }

    @NotNull
    public final String getWhitespace() {
        return this.whitespace;
    }

    public final void setWhitespace(@NotNull String value) {
        this.whitespace = Objects.requireNonNull(value);
    }

    public final T withWhitespace(String whitespace) {
        this.setWhitespace(whitespace);
        return (T)this;
    }

    public final boolean hasComment() {
        return this.comment.length() > 0;
    }

    @NotNull
    public final String getComment() {
        return this.comment;
    }

    public final void setComment(@NotNull String value) {
        this.comment = Objects.requireNonNull(value);
    }

    public final T withComment(String comment) {
        this.setComment(comment);
        return (T)this;
    }

    public boolean isMap() {
        return false;
    }

    public GddlMap asMap() {
        throw new IllegalStateException("This element is not a Collection.");
    }

    public void ifMap(Consumer<GddlMap> consumer) {
        if (this.isMap()) {
            consumer.accept(this.asMap());
        }
    }

    public boolean isList() {
        return false;
    }

    public GddlList asList() {
        throw new IllegalStateException("This element is not a Collection.");
    }

    public void ifList(Consumer<GddlList> consumer) {
        if (this.isList()) {
            consumer.accept(this.asList());
        }
    }

    public boolean isValue() {
        return false;
    }

    public GddlValue asValue() {
        throw new IllegalStateException("This element is not a Value.");
    }

    public void ifValue(Consumer<GddlValue> consumer) {
        if (this.isValue()) {
            consumer.accept(this.asValue());
        }
    }

    public boolean isReference() {
        return false;
    }

    public GddlReference asReference() {
        throw new IllegalStateException("This element is not a Reference.");
    }

    public void ifReference(Consumer<GddlValue> consumer) {
        if (this.isValue()) {
            consumer.accept(this.asValue());
        }
    }

    public boolean isNull() {
        return false;
    }

    public void ifNull(Runnable runnable) {
        if (this.isNull()) {
            runnable.run();
        }
    }

    public boolean isString() {
        return false;
    }

    public String stringValue() {
        throw new IllegalStateException("This element is not a value.");
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean booleanValue() {
        throw new IllegalStateException("This element is not a value.");
    }

    public boolean isInteger() {
        return false;
    }

    public long intValue() {
        throw new IllegalStateException("This element is not a value.");
    }

    public boolean isDouble() {
        return false;
    }

    public double doubleValue() {
        throw new IllegalStateException("This element is not a value.");
    }

    public boolean isCollection() {
        return this.isMap() || this.isList();
    }

    public GddlElement<?> simplify() {
        return this;
    }

    public void resolve(GddlElement<?> root) {
    }

    public Stream<GddlElement<?>> query(String query) {
        return Query.fromString(query).apply(this);
    }

    public boolean isResolved() {
        return true;
    }

    public GddlElement<?> resolvedValue() {
        return this;
    }

    public final String toString() {
        return Formatter.formatCompact(this);
    }

    public final T copy() {
        T c = this.copyInternal();
        ((GddlElement)c).resolve(this);
        return c;
    }

    @Nullable
    public GddlElement<?> getParent() {
        return this.parent;
    }

    GddlElement() {
    }

    protected abstract T copyInternal();

    protected void copyTo(T other) {
        if (this.hasWhitespace()) {
            ((GddlElement)other).setWhitespace(this.getWhitespace());
        }
        if (this.hasComment()) {
            ((GddlElement)other).setComment(this.getComment());
        }
    }

    void setParent(@Nullable GddlElement<?> parent) {
        this.parent = parent;
    }

    public abstract boolean equals(Object var1);

    public abstract boolean equals(T var1);

    protected boolean equalsImpl(GddlElement<?> other) {
        return !this.hasComment() && !other.hasComment() || Objects.equals(this.comment, other.comment);
    }

    public int hashCode() {
        return Objects.hash(this.whitespace, this.comment);
    }

    public int getFormattingComplexity() {
        return 1;
    }
}

