/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2;

import dev.gigaherz.util.gddl2.exceptions.ParserException;
import dev.gigaherz.util.gddl2.parsing.Lexer;
import dev.gigaherz.util.gddl2.parsing.Parser;
import dev.gigaherz.util.gddl2.parsing.Reader;
import dev.gigaherz.util.gddl2.structure.GddlDocument;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;

public class GDDL {
    public static GddlDocument fromFile(String filename) throws ParserException, IOException {
        return GDDL.fromFile(filename, StandardCharsets.UTF_8);
    }

    public static GddlDocument fromFile(String filename, Charset charset) throws ParserException, IOException {
        return GDDL.fromReader(new FileReader(filename, charset), filename);
    }

    public static GddlDocument fromFile(File file) throws ParserException, IOException {
        return GDDL.fromFile(file, StandardCharsets.UTF_8);
    }

    public static GddlDocument fromFile(File file, Charset charset) throws ParserException, IOException {
        return GDDL.fromReader(new FileReader(file, charset), file.getAbsolutePath());
    }

    public static GddlDocument fromFile(Path path) throws ParserException, IOException {
        return GDDL.fromFile(path, StandardCharsets.UTF_8);
    }

    public static GddlDocument fromFile(Path path, Charset charset) throws ParserException, IOException {
        return GDDL.fromReader(Files.newBufferedReader(path, charset), path.toString());
    }

    public static GddlDocument fromStream(InputStream stream) throws ParserException, IOException {
        return GDDL.fromStream(stream, StandardCharsets.UTF_8);
    }

    public static GddlDocument fromStream(InputStream stream, String sourceName) throws ParserException, IOException {
        return GDDL.fromStream(stream, StandardCharsets.UTF_8, sourceName);
    }

    public static GddlDocument fromStream(InputStream stream, Charset charset) throws ParserException, IOException {
        return GDDL.fromStream(stream, charset, "UNKNOWN");
    }

    public static GddlDocument fromStream(InputStream stream, Charset charset, String sourceName) throws ParserException, IOException {
        return GDDL.fromReader(new InputStreamReader(stream, charset), sourceName);
    }

    public static GddlDocument fromString(String text) throws ParserException, IOException {
        return GDDL.fromString(text, "UNKNOWN");
    }

    public static GddlDocument fromString(String text, String sourceName) throws ParserException, IOException {
        return GDDL.fromReader(new StringReader(text), sourceName);
    }

    public static GddlDocument fromReader(java.io.Reader reader) throws ParserException, IOException {
        return GDDL.fromReader(reader, "UNKNOWN");
    }

    public static GddlDocument fromReader(java.io.Reader reader, String sourceName) throws ParserException, IOException {
        Parser parser = new Parser(new Lexer(new Reader(reader, sourceName)));
        return parser.parse();
    }
}

