/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.parsing;

import dev.gigaherz.util.gddl2.exceptions.LexerException;
import dev.gigaherz.util.gddl2.exceptions.ParserException;
import dev.gigaherz.util.gddl2.parsing.ContextProvider;
import dev.gigaherz.util.gddl2.parsing.ParsingContext;
import dev.gigaherz.util.gddl2.parsing.Token;
import dev.gigaherz.util.gddl2.parsing.TokenProvider;
import dev.gigaherz.util.gddl2.parsing.TokenType;
import dev.gigaherz.util.gddl2.parsing.WhitespaceMode;
import dev.gigaherz.util.gddl2.queries.Query;
import dev.gigaherz.util.gddl2.structure.GddlDocument;
import dev.gigaherz.util.gddl2.structure.GddlElement;
import dev.gigaherz.util.gddl2.structure.GddlList;
import dev.gigaherz.util.gddl2.structure.GddlMap;
import dev.gigaherz.util.gddl2.structure.GddlReference;
import dev.gigaherz.util.gddl2.structure.GddlValue;
import dev.gigaherz.util.gddl2.util.BasicIntStack;
import dev.gigaherz.util.gddl2.util.Index;
import dev.gigaherz.util.gddl2.util.Range;
import dev.gigaherz.util.gddl2.util.Utility;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class Parser
implements ContextProvider,
AutoCloseable {
    int prefixPos = -1;
    final BasicIntStack prefixStack = new BasicIntStack();
    private boolean finishedWithRBrace = false;
    private final TokenProvider lexer;

    public Parser(TokenProvider lexer) {
        this.lexer = lexer;
    }

    public WhitespaceMode getWhitespaceMode() {
        return this.lexer.getWhitespaceMode();
    }

    public void setWhitespaceMode(WhitespaceMode whitespaceMode) {
        this.lexer.setWhitespaceMode(whitespaceMode);
    }

    public TokenProvider getLexer() {
        return this.lexer;
    }

    public GddlDocument parse() throws IOException, ParserException {
        return this.parse(false);
    }

    public GddlDocument parse(boolean simplify) throws IOException, ParserException {
        Map.Entry<GddlElement<?>, String> result = this.root();
        GddlElement<?> root = result.getKey();
        if (simplify) {
            root.resolve(root);
            root = root.simplify();
        }
        GddlDocument doc = GddlDocument.create(root);
        doc.setDanglingComment(result.getValue());
        return doc;
    }

    public Query ParseQuery() throws IOException, ParserException {
        return this.QueryPath().path();
    }

    private Token popExpected(TokenType ... expected) throws ParserException, IOException {
        TokenType current = this.lexer.peek();
        if (Arrays.stream(expected).anyMatch(t -> current == t)) {
            return this.lexer.pop();
        }
        if (expected.length != 1) {
            throw new ParserException(this, String.format("Unexpected token %s. Expected one of: %s.", new Object[]{current, Utility.join((CharSequence)", ", expected)}));
        }
        throw new ParserException(this, String.format("Unexpected token %s. Expected: %s.", new Object[]{current, expected[0]}));
    }

    private Token popExpectedWithParent(TokenType ... expected) throws ParserException, IOException {
        Token current = this.lexer.peekFull();
        if (Arrays.stream(expected).anyMatch(current::is)) {
            return this.lexer.pop();
        }
        if (expected.length != 1) {
            throw new ParserException(this, String.format("Unexpected token %s. Expected one of: %s.", current, Utility.join((CharSequence)", ", expected)));
        }
        throw new ParserException(this, String.format("Unexpected token %s. Expected: %s.", new Object[]{current, expected[0]}));
    }

    private void beginPrefixScan() {
        this.prefixStack.push(this.prefixPos);
    }

    private TokenType nextPrefix() throws LexerException, IOException {
        return this.lexer.peek(++this.prefixPos);
    }

    private void endPrefixScan() {
        this.prefixPos = this.prefixStack.pop();
    }

    private boolean hasAny(TokenType ... tokens) throws LexerException, IOException {
        TokenType prefix = this.nextPrefix();
        return Arrays.stream(tokens).anyMatch(t -> prefix == t);
    }

    private Map.Entry<GddlElement<?>, String> root() throws IOException, ParserException {
        GddlElement<?> E = this.element();
        Token end = this.popExpected(TokenType.END);
        return Map.entry(E, end.comment);
    }

    private boolean prefixIdentifier() throws LexerException, IOException {
        this.beginPrefixScan();
        boolean r = this.hasAny(TokenType.IDENTIFIER);
        this.endPrefixScan();
        return r;
    }

    private GddlElement<?> element() throws ParserException, IOException {
        if (this.lexer.peek() == TokenType.NIL) {
            return Parser.nullValue(this.popExpected(TokenType.NIL));
        }
        if (this.lexer.peek() == TokenType.NULL) {
            return Parser.nullValue(this.popExpected(TokenType.NULL));
        }
        if (this.lexer.peek() == TokenType.TRUE) {
            return Parser.booleanValue(this.popExpected(TokenType.TRUE));
        }
        if (this.lexer.peek() == TokenType.FALSE) {
            return Parser.booleanValue(this.popExpected(TokenType.FALSE));
        }
        if (this.lexer.peek() == TokenType.INTEGER_LITERAL) {
            return Parser.intValue(this.popExpected(TokenType.INTEGER_LITERAL));
        }
        if (this.lexer.peek() == TokenType.HEX_INT_LITERAL) {
            return Parser.hexIntValue(this.popExpected(TokenType.HEX_INT_LITERAL));
        }
        if (this.lexer.peek() == TokenType.INTEGER_LITERAL) {
            return Parser.intValue(this.popExpected(TokenType.INTEGER_LITERAL));
        }
        if (this.lexer.peek() == TokenType.DECIMAL_LITERAL) {
            return Parser.floatValue(this.popExpected(TokenType.DECIMAL_LITERAL));
        }
        if (this.lexer.peek() == TokenType.STRING_LITERAL) {
            return Parser.stringValue(this.popExpected(TokenType.STRING_LITERAL));
        }
        if (this.prefixMap()) {
            return this.map();
        }
        if (this.prefixObject()) {
            return this.object();
        }
        if (this.prefixList()) {
            return this.list();
        }
        if (this.prefixReference()) {
            return this.reference();
        }
        throw new ParserException(this, String.format("Internal Error: Token %s did not correspond to any code path.", new Object[]{this.lexer.peek()}));
    }

    private Token name() throws ParserException, IOException {
        return this.popExpected(TokenType.IDENTIFIER, TokenType.STRING_LITERAL);
    }

    private boolean prefixReference() throws LexerException, IOException {
        this.beginPrefixScan();
        boolean r = this.hasAny(TokenType.COLON, TokenType.SLASH) && this.hasAny(TokenType.IDENTIFIER, TokenType.STRING_LITERAL, TokenType.L_BRACKET);
        this.endPrefixScan();
        return r || this.prefixIdentifier();
    }

    private GddlReference reference() throws IOException, ParserException {
        QueryParse queryParse = this.QueryPath();
        GddlReference b = GddlReference.of(queryParse.path);
        b.setComment(queryParse.token.comment);
        return b;
    }

    private QueryParse QueryPath() throws IOException, ParserException {
        AtomicReference<Query> pathRef = new AtomicReference<Query>(new Query());
        Token firstToken = null;
        boolean rooted = false;
        TokenType firstDelimiter = null;
        if (this.lexer.peek() == TokenType.COLON || this.lexer.peek() == TokenType.SLASH) {
            firstToken = this.popExpected(TokenType.COLON, TokenType.SLASH);
            firstDelimiter = firstToken.type;
            pathRef.set(pathRef.get().absolute());
        }
        Token pathToken = this.pathComponent(pathRef);
        if (firstToken == null) {
            firstToken = pathToken;
        }
        while (this.lexer.peek() == TokenType.COLON || this.lexer.peek() == TokenType.SLASH) {
            if (firstDelimiter != null && this.lexer.peek() != firstDelimiter) {
                throw new ParserException(this, String.format("Query must use consistent delimiters, expected %s, found %s instead", new Object[]{firstDelimiter, this.lexer.peek()}));
            }
            firstDelimiter = this.popExpected((TokenType[])new TokenType[]{TokenType.COLON, TokenType.SLASH}).type;
            this.pathComponent(pathRef);
        }
        return new QueryParse(firstToken, pathRef.get());
    }

    private Token pathComponent(AtomicReference<Query> pathRef) throws ParserException, IOException {
        Token token = this.popExpected(TokenType.IDENTIFIER, TokenType.STRING_LITERAL, TokenType.DOT, TokenType.DOUBLE_DOT, TokenType.L_BRACKET);
        Query path = pathRef.get();
        switch (token.type) {
            case IDENTIFIER: {
                path = path.byKey(token.text);
                break;
            }
            case STRING_LITERAL: {
                path = path.byKey(Parser.unescapeString(token));
                break;
            }
            case DOT: {
                path = path.self();
                break;
            }
            case DOUBLE_DOT: {
                path = path.parent();
                break;
            }
            case L_BRACKET: {
                boolean hasStart = false;
                Index start = Index.fromStart(0);
                if (this.lexer.peek() == TokenType.CARET) {
                    this.popExpected(TokenType.CARET);
                    start = Index.fromEnd((int)Parser.intValue(this.popExpected(TokenType.INTEGER_LITERAL)).intValue());
                    hasStart = true;
                } else if (this.lexer.peek() == TokenType.INTEGER_LITERAL) {
                    start = Index.fromStart((int)Parser.intValue(this.popExpected(TokenType.INTEGER_LITERAL)).intValue());
                    hasStart = true;
                }
                if (hasStart && this.lexer.peek() == TokenType.R_BRACKET) {
                    this.popExpected(TokenType.R_BRACKET);
                    path = path.byRange(new Range(start, start.fromEnd() ? Index.fromEnd(start.value() - 1) : Index.fromStart(start.value() + 1)));
                    break;
                }
                Token inclusive = this.popExpected(TokenType.DOUBLE_DOT, TokenType.TRIPLE_DOT);
                Index end = Index.fromEnd(0);
                if (this.lexer.peek() == TokenType.CARET) {
                    this.popExpected(TokenType.CARET);
                    end = Index.fromEnd((int)Parser.intValue(this.popExpected(TokenType.INTEGER_LITERAL)).intValue());
                } else if (this.lexer.peek() == TokenType.INTEGER_LITERAL) {
                    end = Index.fromStart((int)Parser.intValue(this.popExpected(TokenType.INTEGER_LITERAL)).intValue());
                    if (inclusive.type == TokenType.TRIPLE_DOT) {
                        end = end.fromEnd() ? Index.fromEnd(end.value() - 1) : Index.fromStart(end.value() + 1);
                    }
                }
                this.popExpected(TokenType.R_BRACKET);
                path = path.byRange(new Range(start, end));
                break;
            }
            default: {
                throw new ParserException(this.lexer, String.format("Internal Error: Unexpected token %s found when parsing Reference path component", token));
            }
        }
        pathRef.set(path);
        return token;
    }

    private boolean prefixMap() throws LexerException, IOException {
        this.beginPrefixScan();
        boolean r = this.hasAny(TokenType.L_BRACE);
        this.endPrefixScan();
        return r;
    }

    private GddlMap map() throws ParserException, IOException {
        Token openBrace = this.popExpected(TokenType.L_BRACE);
        GddlMap s = GddlMap.empty();
        s.setComment(openBrace.comment);
        while (this.lexer.peek() != TokenType.R_BRACE) {
            this.finishedWithRBrace = false;
            Token name = this.popExpectedWithParent(TokenType.IDENTIFIER, TokenType.STRING_LITERAL);
            String n = name.type == TokenType.STRING_LITERAL ? Parser.unescapeString(name) : name.text;
            this.popExpected(TokenType.EQUAL_SIGN, TokenType.COLON);
            GddlElement<?> b = this.element();
            b.setComment(name.comment);
            b.setWhitespace(name.whitespace);
            s.put(n, b);
            if (this.lexer.peek() == TokenType.R_BRACE || this.finishedWithRBrace && this.lexer.peek() != TokenType.COMMA) continue;
            this.popExpected(TokenType.COMMA);
        }
        Token end = this.popExpected(TokenType.R_BRACE);
        s.setTrailingComment(end.comment);
        this.finishedWithRBrace = true;
        return s;
    }

    private boolean prefixObject() throws LexerException, IOException {
        this.beginPrefixScan();
        boolean r = this.hasAny(TokenType.IDENTIFIER, TokenType.STRING_LITERAL) && this.hasAny(TokenType.L_BRACE);
        this.endPrefixScan();
        return r;
    }

    private GddlMap object() throws IOException, ParserException {
        Token type = this.name();
        GddlMap s = this.map().withTypeName(type.text);
        s.setComment(type.comment);
        return s;
    }

    private boolean prefixList() throws LexerException, IOException {
        this.beginPrefixScan();
        boolean r = this.hasAny(TokenType.L_BRACKET);
        this.endPrefixScan();
        return r;
    }

    private GddlList list() throws ParserException, IOException {
        Token openBrace = this.popExpected(TokenType.L_BRACKET);
        GddlList s = GddlList.empty();
        s.setComment(openBrace.comment);
        while (this.lexer.peek() != TokenType.R_BRACKET) {
            this.finishedWithRBrace = false;
            s.add(this.element());
            if (this.lexer.peek() == TokenType.R_BRACKET || this.finishedWithRBrace && this.lexer.peek() != TokenType.COMMA) continue;
            this.popExpected(TokenType.COMMA);
        }
        Token end = this.popExpected(TokenType.R_BRACKET);
        s.setTrailingComment(end.comment);
        this.finishedWithRBrace = true;
        return s;
    }

    private static GddlValue nullValue(Token token) {
        GddlValue e = GddlValue.nullValue();
        e.setComment(token.comment);
        return e;
    }

    private static GddlValue booleanValue(Token token) {
        GddlValue e = GddlValue.of(token.type == TokenType.TRUE);
        e.setComment(token.comment);
        return e;
    }

    private static GddlValue intValue(Token token) {
        GddlValue e = GddlValue.of(Long.parseLong(token.text));
        e.setComment(token.comment);
        return e;
    }

    private static GddlValue hexIntValue(Token token) {
        long num = Long.parseLong(token.text.substring(2), 16);
        GddlValue e = GddlValue.of(num);
        e.setComment(token.comment);
        return e;
    }

    private static GddlValue floatValue(Token token) {
        double value = switch (token.text) {
            case ".NaN" -> Double.NaN;
            case ".Inf", "+.Inf" -> Double.POSITIVE_INFINITY;
            case "-.Inf" -> Double.NEGATIVE_INFINITY;
            default -> Double.parseDouble(token.text);
        };
        GddlValue e = GddlValue.of(value);
        e.setComment(token.comment);
        return e;
    }

    private static GddlValue stringValue(Token token) throws ParserException {
        GddlValue e = GddlValue.of(Parser.unescapeString(token));
        e.setComment(token.comment);
        return e;
    }

    private static String unescapeString(Token t) throws ParserException {
        try {
            return Utility.unescapeString(t.text);
        }
        catch (IllegalArgumentException ex) {
            throw new ParserException(t, "Unescaping string", ex);
        }
    }

    public String toString() {
        return String.format("{Parser lexer=%s}", this.lexer);
    }

    @Override
    public ParsingContext getParsingContext() {
        return this.lexer.getParsingContext();
    }

    @Override
    public void close() throws Exception {
        this.lexer.close();
    }

    private record QueryParse(Token token, Query path) {
    }
}

