/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.structure;

import dev.gigaherz.util.gddl2.structure.GddlElement;
import dev.gigaherz.util.gddl2.structure.GddlMap;
import dev.gigaherz.util.gddl2.util.Range;
import dev.gigaherz.util.gddl2.util.Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class GddlList
extends GddlElement<GddlList>
implements List<GddlElement<?>> {
    private final List<GddlElement<?>> contents = new ArrayList();
    private String trailingComment;

    public static GddlList empty() {
        return new GddlList();
    }

    public static GddlList of(GddlElement<?> ... initial) {
        return new GddlList(Arrays.asList(initial));
    }

    public static GddlList copyOf(Collection<GddlElement<?>> initial) {
        return new GddlList(initial);
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public GddlList asList() {
        return this;
    }

    public boolean hasTrailingComment() {
        return !Utility.isNullOrEmpty(this.trailingComment);
    }

    public String getTrailingComment() {
        return this.trailingComment;
    }

    public void setTrailingComment(String trailingComment) {
        this.trailingComment = trailingComment;
    }

    @NotNull
    public Stream<GddlMap> byType(String typeName) {
        return this.contents.stream().filter(GddlElement::isMap).map(GddlElement::asMap).filter(e -> e.hasTypeName() && e.getTypeName().equals(typeName));
    }

    @Override
    public boolean add(GddlElement<?> e) {
        Objects.requireNonNull(e);
        this.contents.add(e);
        this.onAdd(e);
        return true;
    }

    @Override
    public void add(int before, @NotNull GddlElement<?> e) {
        Objects.requireNonNull(e);
        this.contents.add(before, e);
        this.onAdd(e);
    }

    public boolean remove(GddlElement<?> e) {
        boolean r = this.contents.remove(e);
        this.onRemove(e);
        return r;
    }

    @Override
    public GddlElement<?> remove(int index) {
        GddlElement<?> at = this.contents.get(index);
        this.contents.remove(index);
        this.onRemove(at);
        return at;
    }

    public boolean contains(GddlElement<?> element) {
        return this.contents.contains(element);
    }

    public List<GddlElement<?>> get(Range range) {
        int start = range.offset(this.contents.size());
        int length = range.length(this.contents.size());
        return this.contents.subList(start, length);
    }

    @Override
    public GddlElement<?> get(int index) {
        return this.contents.get(index);
    }

    @Override
    public GddlElement<?> set(int index, @NotNull GddlElement<?> e) {
        Objects.requireNonNull(e);
        GddlElement<?> old = this.contents.get(index);
        if (old != e) {
            this.contents.set(index, e);
            this.onRemove(old);
            this.onAdd(e);
        }
        return old;
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    @Override
    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    @Override
    public void clear() {
        this.contents.forEach(this::onRemove);
        this.contents.clear();
    }

    @Override
    public int getFormattingComplexity() {
        return 2 + this.contents.stream().mapToInt(GddlElement::getFormattingComplexity).sum();
    }

    public int indexOf(GddlElement<?> o) {
        return this.contents.indexOf(o);
    }

    public int lastIndexOf(GddlElement<?> o) {
        return this.contents.lastIndexOf(o);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.contents.containsAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.removeIf(c::contains);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return this.removeIf(Predicate.not(c::contains));
    }

    @Override
    public boolean addAll(Collection<? extends GddlElement<?>> c) {
        c.forEach(this::add);
        return !c.isEmpty();
    }

    @Override
    public boolean addAll(int index, Collection<? extends GddlElement<?>> c) {
        for (GddlElement<?> e : c) {
            this.add(index++, e);
        }
        return !c.isEmpty();
    }

    private GddlList() {
    }

    private GddlList(Collection<GddlElement<?>> init) {
        this.addAll((Collection<? extends GddlElement<?>>)init);
    }

    private void onAdd(GddlElement<?> e) {
        e.setParent(this);
    }

    private void onRemove(GddlElement<?> e) {
        e.setParent(null);
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        return this.contents.toArray();
    }

    @Override
    @NotNull
    public <T> @NotNull T @NotNull [] toArray(@NotNull @NotNull T @NotNull [] a) {
        return this.contents.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        return o instanceof GddlElement && this.remove((GddlElement)o);
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof GddlElement && this.contains((GddlElement)o);
    }

    @Override
    public int indexOf(Object o) {
        return o instanceof GddlElement ? this.indexOf((GddlElement)o) : -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return o instanceof GddlElement ? this.lastIndexOf((GddlElement)o) : -1;
    }

    @Override
    protected GddlList copyInternal() {
        GddlList collection = new GddlList();
        this.copyTo(collection);
        return collection;
    }

    @Override
    protected void copyTo(GddlList other) {
        super.copyTo(other);
        for (GddlElement<?> e : this.contents) {
            other.add((GddlElement<?>)e.copy());
        }
    }

    @Override
    public void resolve(GddlElement<?> root) {
        for (GddlElement<?> el : this.contents) {
            el.resolve(root);
        }
    }

    public GddlList simplify() {
        for (int i = 0; i < this.contents.size(); ++i) {
            this.contents.set(i, this.contents.get(i).simplify());
        }
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.equalsImpl((GddlList)other);
    }

    @Override
    public boolean equals(GddlList other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.equalsImpl(other);
    }

    public boolean equalsImpl(@NotNull GddlList other) {
        return Utility.listEquals(this.contents, other.contents);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.contents);
    }

    @Override
    @NotNull
    public Iterator<GddlElement<?>> iterator() {
        return new Iterator<GddlElement<?>>(){
            private GddlElement<?> current;
            private final Iterator<GddlElement<?>> it;
            {
                this.it = GddlList.this.contents.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public GddlElement<?> next() {
                this.current = this.it.next();
                return this.current;
            }

            @Override
            public void remove() {
                this.it.remove();
                GddlList.this.onRemove(this.current);
            }
        };
    }

    @Override
    @NotNull
    public ListIterator<GddlElement<?>> listIterator() {
        return this.listIterator(0);
    }

    @Override
    @NotNull
    public ListIterator<GddlElement<?>> listIterator(final int index) {
        return new ListIterator<GddlElement<?>>(){
            private final ListIterator<GddlElement<?>> lit;
            private GddlElement<?> current;
            {
                this.lit = GddlList.this.contents.listIterator(index);
                this.current = GddlList.this.contents.get(index);
            }

            @Override
            public boolean hasNext() {
                return this.lit.hasNext();
            }

            @Override
            public GddlElement<?> next() {
                this.current = this.lit.next();
                return this.current;
            }

            @Override
            public boolean hasPrevious() {
                return this.lit.hasPrevious();
            }

            @Override
            public GddlElement<?> previous() {
                this.current = this.lit.previous();
                return this.current;
            }

            @Override
            public int nextIndex() {
                return this.lit.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.lit.previousIndex();
            }

            @Override
            public void remove() {
                this.lit.remove();
                GddlList.this.onRemove(this.current);
            }

            @Override
            public void set(GddlElement<?> e) {
                Objects.requireNonNull(e);
                GddlList.this.onRemove(this.current);
                this.lit.set(e);
                GddlList.this.onAdd(e);
            }

            @Override
            public void add(GddlElement<?> e) {
                Objects.requireNonNull(e);
                this.lit.add(e);
                GddlList.this.onAdd(e);
            }
        };
    }

    @Override
    @NotNull
    public List<GddlElement<?>> subList(int fromIndex, int toIndex) {
        return Collections.unmodifiableList(this.contents.subList(fromIndex, toIndex));
    }
}

