/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.formatting;

import dev.gigaherz.util.gddl2.formatting.FormatterOptions;
import dev.gigaherz.util.gddl2.queries.QueryComponent;
import dev.gigaherz.util.gddl2.structure.GddlDocument;
import dev.gigaherz.util.gddl2.structure.GddlElement;
import dev.gigaherz.util.gddl2.structure.GddlList;
import dev.gigaherz.util.gddl2.structure.GddlMap;
import dev.gigaherz.util.gddl2.structure.GddlReference;
import dev.gigaherz.util.gddl2.structure.GddlValue;
import dev.gigaherz.util.gddl2.util.BasicIntStack;
import dev.gigaherz.util.gddl2.util.Utility;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public class Formatter {
    private static final Pattern COMMENT_LINE_SPLITTER = Pattern.compile("\n|\r\n");
    private final BasicIntStack indentLevels = new BasicIntStack();
    private final FormatterOptions options;
    private final StringBuilder builder;
    private int indentLevel = 0;

    public static String formatCompact(GddlDocument doc) {
        return Formatter.format(doc, FormatterOptions.COMPACT);
    }

    public static String formatCompact(GddlElement<?> element) {
        return Formatter.format(element, FormatterOptions.COMPACT);
    }

    public static String formatNice(GddlDocument doc) {
        return Formatter.format(doc, FormatterOptions.NICE);
    }

    public static String formatNice(GddlElement<?> element) {
        return Formatter.format(element, FormatterOptions.NICE);
    }

    public static String format(GddlDocument doc, FormatterOptions options) {
        StringBuilder b = new StringBuilder();
        Formatter f = new Formatter(b, options);
        f.formatDocument(doc);
        return b.toString();
    }

    public static String format(GddlElement<?> element, FormatterOptions options) {
        StringBuilder b = new StringBuilder();
        Formatter f = new Formatter(b, options);
        f.formatElement(element);
        return b.toString();
    }

    public Formatter(StringBuilder builder, FormatterOptions options) {
        this.builder = builder;
        this.options = options;
    }

    public void formatDocument(GddlDocument d) {
        this.formatElement(d.getRoot());
        if (d.hasDanglingComment() && this.options.writeComments) {
            this.formatComment(d.getDanglingComment());
        }
    }

    public void formatElement(GddlElement<?> e) {
        this.formatComment(e);
        this.appendIndent();
        this.formatElement(e, false);
    }

    public FormatterOptions getOptions() {
        return this.options;
    }

    private void pushIndent() {
        this.indentLevels.push(this.indentLevel);
    }

    private void popIndent() {
        this.indentLevel = this.indentLevels.pop();
    }

    private void clearIndent() {
        this.indentLevel = 0;
    }

    private void incIndent() {
        ++this.indentLevel;
    }

    private void appendMultiple(char c, int n) {
        for (int i = 0; i < n; ++i) {
            this.builder.append(c);
        }
    }

    private void appendIndent() {
        int tabsToGen = this.indentLevel;
        for (int i = 0; i < tabsToGen; ++i) {
            if (this.options.indentUsingTabs) {
                this.builder.append('\t');
                continue;
            }
            this.appendMultiple(' ', this.options.spacesPerIndent);
        }
    }

    private void formatComment(GddlElement<?> e) {
        if (e.hasComment() && this.options.writeComments) {
            this.formatComment(e.getComment());
        }
    }

    private void formatComment(String comment) {
        int count;
        this.appendMultiple('\n', this.options.blankLinesBeforeComment);
        String[] lines = COMMENT_LINE_SPLITTER.split(comment, -1);
        if (count > 0 && this.options.trimCommentLines) {
            for (count = lines.length; count > 0 && lines[count - 1].length() == 0; --count) {
            }
        }
        for (int i = 0; i < count; ++i) {
            this.appendIndent();
            this.builder.append('#');
            this.builder.append(lines[i]);
            this.builder.append('\n');
        }
    }

    private void formatElement(GddlElement<?> e, boolean hasNext) {
        if (e.isValue()) {
            this.formatValue(e.asValue());
        } else if (e.isReference()) {
            this.formatReference(e.asReference());
        } else if (e.isMap()) {
            this.formatMap(e.asMap(), hasNext);
        } else if (e.isList()) {
            this.formatList(e.asList(), hasNext);
        } else {
            throw new IllegalStateException("A new Element type has been added without updating Formatter#formatElement.");
        }
    }

    private void formatValue(GddlValue v) {
        if (v.isNull()) {
            this.builder.append("null");
        } else if (v.isBoolean()) {
            this.builder.append(v.booleanValue() ? "true" : "false");
        } else if (v.isInteger()) {
            this.formatInteger(v.intValue());
        } else if (v.isDouble()) {
            this.formatDoubleCustom(v.doubleValue());
        } else if (v.isString()) {
            this.builder.append(Utility.escapeString(v.stringValue()));
        } else {
            throw new IllegalStateException("A new Value type has been added without updating Formatter#formatValue.");
        }
    }

    private void formatInteger(long value) {
        this.builder.append(String.format(Locale.ROOT, "%d", value));
    }

    private void formatDoubleCustom(double value) {
        switch (this.options.floatFormattingStyle) {
            case DECIMAL: {
                this.formatDoubleDecimal(value);
                break;
            }
            case SCIENTIFIC: {
                this.formatDoubleScientific(value);
                break;
            }
            default: {
                this.formatDoubleAuto(value);
            }
        }
    }

    private void formatDoubleAuto(double value) {
        if (this.formatSpecial(value)) {
            return;
        }
        int exp = (int)Math.floor(Math.log10(Math.abs(value)));
        if (exp >= this.options.autoScientificNotationUpper || exp < this.options.autoScientificNotationLower) {
            this.formatDoubleScientific(value);
        } else {
            this.formatDoubleDecimal(value);
        }
    }

    private void formatDoubleScientific(double value) {
        if (this.formatSpecial(value)) {
            return;
        }
        int exp = (int)Math.floor(Math.log10(Math.abs(value)));
        double adjusted = value / Math.pow(10.0, exp);
        this.formatDoubleDecimal(adjusted);
        this.builder.append('e');
        if (this.options.alwaysShowExponentSign) {
            this.formatSign(exp);
        } else {
            this.formatNegative(exp);
        }
        this.formatInteger(Math.abs(exp));
    }

    private void formatDoubleDecimal(double value) {
        if (this.options.alwaysShowNumberSign) {
            this.formatSign(value);
        } else {
            this.formatNegative(value);
        }
        value = Math.abs(value);
        double integral = Math.floor(value);
        double fractional = value - integral;
        int exp = integral > 0.0 ? (int)Math.floor(Math.log10(integral) + 1.0) : 0;
        ArrayList<Integer> temp1 = new ArrayList<Integer>();
        double leftovers = this.getDigitsForRounding(temp1, this.options.floatSignificantFigures - exp, fractional);
        int nonTrailingDigits = this.roundDigits(temp1, leftovers);
        if (nonTrailingDigits < 0) {
            nonTrailingDigits ^= 0xFFFFFFFF;
            integral += 1.0;
        }
        this.formatIntegral(integral, exp);
        this.builder.append('.');
        this.formatFractional(temp1, nonTrailingDigits);
    }

    private void formatIntegral(double integral, int exp) {
        if (!(integral > 0.0)) {
            this.builder.append('0');
            return;
        }
        double value = integral / Math.pow(10.0, exp);
        ArrayList<Integer> temp = new ArrayList<Integer>();
        double leftovers = this.getDigitsForRounding(temp, Math.min(exp, this.options.floatSignificantFigures), value);
        int nonTrailingDigits1 = this.roundDigits(temp, leftovers);
        int nonTrailingDigits = this.formatDigitsAfterRounding(temp, nonTrailingDigits1);
        this.appendMultiple('0', exp - nonTrailingDigits);
    }

    private void formatFractional(List<Integer> temp, int nonTrailingDigits) {
        this.formatDigitsAfterRounding(temp, nonTrailingDigits);
    }

    private double getDigitsForRounding(List<Integer> temp, int exp, double value) {
        temp.clear();
        while (value > 0.0 && temp.size() < exp) {
            int digit = (int)Math.floor(value *= 10.0);
            value -= (double)digit;
            temp.add(digit);
        }
        if (temp.size() == 0) {
            temp.add(0);
        }
        return value;
    }

    private int formatDigitsAfterRounding(List<Integer> temp, int nonTrailingDigits) {
        for (int i = 0; i < nonTrailingDigits; ++i) {
            this.builder.append((char)(48 + temp.get(i)));
        }
        return nonTrailingDigits;
    }

    private int roundDigits(List<Integer> temp, double leftovers) {
        int r;
        int n = r = leftovers >= 0.5 ? 1 : 0;
        for (int l = temp.size() - 1; r > 0 && l >= 0; --l) {
            int v = temp.get(l);
            if (++v >= 10) {
                v -= 10;
            } else {
                r = 0;
            }
            temp.set(l, v);
        }
        int firstTrailingZero = 1;
        for (int i = temp.size() - 1; i >= 0; --i) {
            if (temp.get(i) == 0) continue;
            firstTrailingZero = i + 1;
            break;
        }
        return r > 0 ? ~firstTrailingZero : firstTrailingZero;
    }

    private boolean formatSpecial(double value) {
        if (Double.isNaN(value)) {
            this.builder.append(".NaN");
            return true;
        }
        if (Double.isInfinite(value)) {
            if (this.options.alwaysShowNumberSign) {
                this.formatSign(value);
            } else {
                this.formatNegative(value);
            }
            this.builder.append(".Inf");
            return true;
        }
        return false;
    }

    private void formatNegative(double value) {
        long l = Double.doubleToRawLongBits(value);
        if (l < 0L) {
            this.builder.append('-');
        }
    }

    private void formatSign(double value) {
        long l = Double.doubleToRawLongBits(value);
        this.builder.append(l < 0L ? "-" : "+");
    }

    private void formatReference(GddlReference r) {
        int count = 0;
        for (QueryComponent it : r.getNameParts()) {
            if (count++ > 0) {
                this.builder.append(this.options.useJsonDelimiters ? (char)'/' : ':');
            }
            this.builder.append(it.toString(this));
        }
    }

    private void formatMap(GddlMap c, boolean hasNext0) {
        boolean oneElementPerLine;
        this.pushIndent();
        boolean bl = oneElementPerLine = c.getFormattingComplexity() > this.options.oneElementPerLineThreshold;
        if (c.hasTypeName()) {
            this.builder.append(c.getTypeName());
            if (this.options.lineBreaksBeforeOpeningBrace == 0) {
                this.builder.append(' ');
            }
        }
        if (oneElementPerLine && this.options.lineBreaksBeforeOpeningBrace > 0) {
            this.appendMultiple('\n', this.options.lineBreaksBeforeOpeningBrace);
            this.appendIndent();
        } else if (this.options.spacesBeforeOpeningBrace > 0) {
            this.appendMultiple(' ', this.options.spacesBeforeOpeningBrace);
        }
        this.builder.append('{');
        if (c.size() == 0 && !oneElementPerLine) {
            this.appendMultiple(' ', this.options.spacesInEmptyCollection);
        } else if (oneElementPerLine && this.options.lineBreaksAfterOpeningBrace > 0) {
            this.appendMultiple('\n', this.options.lineBreaksAfterOpeningBrace);
        } else if (this.options.spacesAfterOpeningBrace > 0) {
            this.appendMultiple(' ', this.options.spacesAfterOpeningBrace);
        }
        this.pushIndent();
        this.incIndent();
        boolean first = true;
        ArrayList<String> keys = new ArrayList<String>(c.keySet());
        if (this.options.sortMapKeys) {
            keys.sort(String::compareTo);
        }
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            GddlElement<?> e = c.get(key);
            this.pushIndent();
            if (first && (!oneElementPerLine || this.options.lineBreaksAfterOpeningBrace == 0)) {
                this.clearIndent();
            } else if (!first) {
                if (oneElementPerLine) {
                    this.builder.append("\n");
                } else {
                    this.appendMultiple(' ', this.options.spacesAfterComma);
                }
                if (!oneElementPerLine) {
                    this.clearIndent();
                }
            }
            boolean hasNext1 = i + 1 < c.size();
            this.formatComment(e);
            this.appendIndent();
            if (this.options.alwaysUseStringLiterals || !Utility.isValidIdentifier(key)) {
                key = Utility.escapeString(key);
            }
            this.builder.append(key);
            this.appendMultiple(' ', this.options.spacesBeforeEquals);
            this.builder.append(this.options.useJsonDelimiters ? (char)':' : '=');
            this.appendMultiple(' ', this.options.spacesAfterEquals);
            this.formatElement(e, hasNext1);
            if (!(!hasNext1 || e.isCollection() && this.options.omitCommaAfterClosingBrace)) {
                this.appendMultiple(' ', this.options.spacesBeforeComma);
                this.builder.append(',');
            }
            first = false;
            this.popIndent();
        }
        if (c.hasTrailingComment() && this.options.writeComments) {
            this.formatComment(c.getTrailingComment());
        }
        this.popIndent();
        if (c.size() != 0 || oneElementPerLine) {
            if (oneElementPerLine && this.options.lineBreaksBeforeClosingBrace > 0) {
                this.appendMultiple('\n', this.options.lineBreaksBeforeClosingBrace);
                this.appendIndent();
            } else if (this.options.spacesBeforeClosingBrace > 0) {
                this.appendMultiple(' ', this.options.spacesBeforeClosingBrace);
            }
        }
        this.builder.append('}');
        if (!hasNext0 || this.options.omitCommaAfterClosingBrace) {
            if (oneElementPerLine && this.options.lineBreaksAfterClosingBrace > 0) {
                this.appendMultiple('\n', this.options.lineBreaksAfterClosingBrace);
            } else if (this.options.spacesAfterClosingBrace > 0) {
                this.appendMultiple(' ', this.options.spacesAfterClosingBrace);
            }
        }
        this.popIndent();
    }

    private void formatList(GddlList c, boolean hasNext0) {
        boolean oneElementPerLine;
        this.pushIndent();
        boolean bl = oneElementPerLine = c.getFormattingComplexity() > this.options.oneElementPerLineThreshold;
        if (oneElementPerLine && this.options.lineBreaksBeforeOpeningBrace > 0) {
            this.appendMultiple('\n', this.options.lineBreaksBeforeOpeningBrace);
            this.appendIndent();
        } else if (this.options.spacesBeforeOpeningBrace > 0) {
            this.appendMultiple(' ', this.options.spacesBeforeOpeningBrace);
        }
        this.builder.append('[');
        if (oneElementPerLine && this.options.lineBreaksAfterOpeningBrace > 0) {
            this.appendMultiple('\n', this.options.lineBreaksAfterOpeningBrace);
        } else if (this.options.spacesAfterOpeningBrace > 0) {
            this.appendMultiple(' ', this.options.spacesAfterOpeningBrace);
        }
        this.pushIndent();
        this.incIndent();
        boolean first = true;
        for (int i = 0; i < c.size(); ++i) {
            Object e = c.get(i);
            this.pushIndent();
            if (first && (!oneElementPerLine || this.options.lineBreaksAfterOpeningBrace == 0)) {
                this.clearIndent();
            } else if (!first) {
                if (oneElementPerLine) {
                    this.builder.append("\n");
                } else if (this.options.spacesAfterComma > 0) {
                    this.appendMultiple(' ', this.options.spacesAfterComma);
                }
                if (!oneElementPerLine) {
                    this.clearIndent();
                }
            }
            boolean hasNext1 = i + 1 < c.size();
            this.formatComment((GddlElement<?>)e);
            this.appendIndent();
            this.formatElement((GddlElement<?>)e, hasNext1);
            if (hasNext1 && (!((GddlElement)e).isMap() && !((GddlElement)e).isList() || !this.options.omitCommaAfterClosingBrace)) {
                this.appendMultiple(' ', this.options.spacesBeforeComma);
                this.builder.append(',');
            }
            first = false;
            this.popIndent();
        }
        if (c.hasTrailingComment() && this.options.writeComments) {
            this.formatComment(c.getTrailingComment());
        }
        this.popIndent();
        if (oneElementPerLine && this.options.lineBreaksBeforeClosingBrace > 0) {
            this.appendMultiple('\n', this.options.lineBreaksBeforeClosingBrace);
            this.appendIndent();
        } else if (this.options.spacesBeforeClosingBrace > 0) {
            this.appendMultiple(' ', this.options.spacesBeforeClosingBrace);
        }
        this.builder.append(']');
        if (!hasNext0 || this.options.omitCommaAfterClosingBrace) {
            if (oneElementPerLine && this.options.lineBreaksAfterClosingBrace > 0) {
                this.appendMultiple('\n', this.options.lineBreaksAfterClosingBrace);
            } else if (this.options.spacesAfterClosingBrace > 0) {
                this.appendMultiple(' ', this.options.spacesAfterClosingBrace);
            }
        }
        this.popIndent();
    }
}

