/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.queries;

import dev.gigaherz.util.gddl2.exceptions.ParserException;
import dev.gigaherz.util.gddl2.parsing.Lexer;
import dev.gigaherz.util.gddl2.parsing.Parser;
import dev.gigaherz.util.gddl2.parsing.Reader;
import dev.gigaherz.util.gddl2.queries.ListQueryComponent;
import dev.gigaherz.util.gddl2.queries.MapQueryComponent;
import dev.gigaherz.util.gddl2.queries.ParentQueryComponent;
import dev.gigaherz.util.gddl2.queries.QueryComponent;
import dev.gigaherz.util.gddl2.queries.SelfQueryComponent;
import dev.gigaherz.util.gddl2.structure.GddlElement;
import dev.gigaherz.util.gddl2.util.Range;
import dev.gigaherz.util.gddl2.util.Utility;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class Query {
    private boolean absolute = false;
    private final List<QueryComponent> pathComponents = new ArrayList<QueryComponent>();

    public static Query fromString(String pathExpression) {
        try {
            Reader reader = new Reader(new StringReader(pathExpression), "QueryParser.ParsePath(String)");
            Lexer lexer = new Lexer(reader);
            Parser parser = new Parser(lexer);
            return parser.parseQuery();
        }
        catch (ParserException | IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public List<QueryComponent> pathComponents() {
        return Collections.unmodifiableList(this.pathComponents);
    }

    public Query absolute() {
        if (this.pathComponents.size() > 0) {
            throw new IllegalStateException("Cannot set Absolute after path components have been added.");
        }
        this.absolute = true;
        return this;
    }

    public Query byKey(String name) {
        this.pathComponents.add(new MapQueryComponent(name));
        return this;
    }

    public Query byRange(Range range) {
        this.pathComponents.add(new ListQueryComponent(range));
        return this;
    }

    public Query self() {
        this.pathComponents.add(SelfQueryComponent.INSTANCE);
        return this;
    }

    public Query parent() {
        this.pathComponents.add(ParentQueryComponent.INSTANCE);
        return this;
    }

    public Stream<GddlElement<?>> apply(GddlElement<?> target) {
        Stream<GddlElement<?>> result = Stream.of(target);
        for (QueryComponent part : this.pathComponents) {
            result = part.filter(result);
        }
        return result;
    }

    public Query copy() {
        Query path = new Query();
        this.copyTo(path);
        return path;
    }

    public void copyTo(Query other) {
        for (QueryComponent component : this.pathComponents) {
            other.pathComponents.add(component.copy());
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.equalsImpl((Query)other);
    }

    public boolean equals(Query other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.equalsImpl(other);
    }

    private boolean equalsImpl(Query other) {
        return this.absolute == other.absolute && Utility.listEquals(this.pathComponents, other.pathComponents);
    }

    public int hashCode() {
        return Objects.hash(this.absolute, this.pathComponents);
    }
}

