/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.serialization;

import dev.gigaherz.util.gddl2.serialization.mappers.ArrayMapper;
import dev.gigaherz.util.gddl2.serialization.mappers.EnumMapper;
import dev.gigaherz.util.gddl2.serialization.mappers.GddlMapper;
import dev.gigaherz.util.gddl2.serialization.mappers.GenericObjectMapper;
import dev.gigaherz.util.gddl2.serialization.mappers.ListMapper;
import dev.gigaherz.util.gddl2.serialization.mappers.MapMapper;
import dev.gigaherz.util.gddl2.serialization.mappers.MapperBase;
import dev.gigaherz.util.gddl2.serialization.mappers.PrimitiveTypeMapper;
import dev.gigaherz.util.gddl2.serialization.mappers.SetMapper;
import dev.gigaherz.util.gddl2.serialization.mappers.StringMapper;
import dev.gigaherz.util.gddl2.structure.GddlMap;
import java.util.ArrayList;
import java.util.List;

public class GddlSerializer {
    public static final int PRIORITY_INTERFACE = Integer.MAX_VALUE;
    public static final int PRIORITY_USER = 0;
    public static final int PRIORITY_PRIMITIVE = -200;
    public static final int PRIORITY_COLLECTION = -300;
    private final List<MapperBase> mappers = new ArrayList<MapperBase>();
    private final GenericObjectMapper generic = new GenericObjectMapper(Integer.MIN_VALUE);

    public GddlSerializer() {
        this(true);
    }

    public GddlSerializer(boolean registerStockMappers) {
        if (registerStockMappers) {
            this.registerMapper(new PrimitiveTypeMapper(-200));
            this.registerMapper(new StringMapper(-200));
            this.registerMapper(new EnumMapper(-200));
            this.registerMapper(new ArrayMapper(-200));
            this.registerMapper(new ListMapper(-300));
            this.registerMapper(new MapMapper(-300));
            this.registerMapper(new SetMapper(-300));
            this.registerMapper(new GddlMapper(-299));
        }
    }

    public void registerMapper(MapperBase mapper) {
        int prio = mapper.getPriority();
        for (int i = 0; i < this.mappers.size(); ++i) {
            MapperBase existing = this.mappers.get(i);
            if (existing.getPriority() < prio) {
                this.mappers.add(i, mapper);
                return;
            }
            if (!existing.equals(mapper)) continue;
            throw new IllegalArgumentException();
        }
        this.mappers.add(mapper);
    }

    private MapperBase findTopFieldMapperForClass(Class<?> clazz) {
        for (MapperBase mapper : this.mappers) {
            if (!mapper.canMapToField(clazz)) continue;
            return mapper;
        }
        return null;
    }

    private MapperBase findTopCompoundMapperForClass(Class<?> clazz) {
        for (MapperBase mapper : this.mappers) {
            if (!mapper.canMapToMap(clazz)) continue;
            return mapper;
        }
        return null;
    }

    public void serializeTo(GddlMap tag, String fieldName, Object object) throws ReflectiveOperationException {
        MapperBase mapper;
        if (object != null && (mapper = this.findTopFieldMapperForClass(object.getClass())) != null) {
            mapper.serializeField(tag, fieldName, object, this);
            return;
        }
        this.generic.serializeField(tag, fieldName, object, this);
    }

    public GddlMap serialize(Object object) throws ReflectiveOperationException {
        MapperBase mapper;
        if (object != null && (mapper = this.findTopCompoundMapperForClass(object.getClass())) != null) {
            return mapper.serializeMap(object, this);
        }
        return this.generic.serializeMap(object, this);
    }

    public <T> T deserialize(Class<? extends T> clazz, GddlMap tag) throws ReflectiveOperationException {
        MapperBase mapper = this.findTopCompoundMapperForClass(clazz);
        if (mapper != null) {
            return (T)mapper.deserializeMap(tag, clazz, this);
        }
        return (T)this.generic.deserializeMap(tag, clazz, this);
    }

    public Object deserializeFrom(GddlMap parent, String fieldName, Class<?> clazz, Object currentValue) throws ReflectiveOperationException {
        if (!parent.containsKey(fieldName)) {
            return currentValue;
        }
        MapperBase mapper = this.findTopFieldMapperForClass(clazz);
        if (mapper != null) {
            return mapper.deserializeField(parent, fieldName, clazz, this);
        }
        return this.generic.deserializeField(parent, fieldName, clazz, this);
    }
}

