/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.serialization.mappers;

import dev.gigaherz.util.gddl2.serialization.GddlSerializationException;
import dev.gigaherz.util.gddl2.serialization.GddlSerializer;
import dev.gigaherz.util.gddl2.serialization.mappers.MapperBase;
import dev.gigaherz.util.gddl2.structure.GddlElement;
import dev.gigaherz.util.gddl2.structure.GddlList;
import dev.gigaherz.util.gddl2.structure.GddlMap;
import java.lang.reflect.Array;

public class ArrayMapper
extends MapperBase {
    public ArrayMapper(int priority) {
        super(priority);
    }

    @Override
    public boolean canMapToField(Class<?> clazz) {
        return clazz.isArray();
    }

    @Override
    public boolean canMapToMap(Class<?> clazz) {
        return clazz.isArray();
    }

    @Override
    public void serializeField(GddlMap parent, String fieldName, Object object, GddlSerializer serializer) throws ReflectiveOperationException {
        parent.put(fieldName, this.serializeArray(object, serializer));
    }

    @Override
    public Object deserializeField(GddlMap parent, String fieldName, Class<?> clazz, GddlSerializer serializer) throws ReflectiveOperationException {
        GddlMap tag2 = (GddlMap)parent.get(fieldName);
        return this.deserializeArray(tag2, clazz, serializer);
    }

    @Override
    public GddlMap serializeMap(Object object, GddlSerializer serializer) throws ReflectiveOperationException {
        return this.serializeArray(object, serializer);
    }

    @Override
    public Object deserializeMap(GddlMap self, Class<?> clazz, GddlSerializer serializer) throws ReflectiveOperationException {
        return this.deserializeArray(self, clazz, serializer);
    }

    private GddlMap serializeArray(Object a, GddlSerializer serializer) throws ReflectiveOperationException {
        GddlMap tag = this.getTypeCompound(a, "array");
        GddlList list = GddlList.empty();
        for (int ii = 0; ii < Array.getLength(a); ++ii) {
            Object o = Array.get(a, ii);
            GddlMap tag2 = GddlMap.empty();
            tag2.put("index", ii);
            if (o != null) {
                serializer.serializeTo(tag2, "valueClass", o.getClass().getName());
                serializer.serializeTo(tag2, "value", o);
            }
            list.add(tag2);
        }
        tag.put("elements", list);
        return tag;
    }

    private Object deserializeArray(GddlMap tag, Class<?> clazz, GddlSerializer serializer) throws ReflectiveOperationException {
        if (!tag.getString("type").equals("array")) {
            throw new GddlSerializationException();
        }
        GddlList list = tag.getList("elements");
        Object o = Array.newInstance(clazz.getComponentType(), list.size());
        for (GddlElement<?> gddlElement : list) {
            GddlMap tag2 = (GddlMap)gddlElement;
            int index = (int)tag2.getInt("index");
            if (!tag2.containsKey("value")) continue;
            Class<?> cls = Class.forName(tag2.getString("valueClass"));
            Object value = serializer.deserializeFrom(tag2, "value", cls, null);
            if (cls == Byte.class || cls == Byte.TYPE) {
                Array.setByte(o, index, (Byte)value);
                continue;
            }
            if (cls == Short.class || cls == Short.TYPE) {
                Array.setShort(o, index, (Short)value);
                continue;
            }
            if (cls == Integer.class || cls == Integer.TYPE) {
                Array.setInt(o, index, (Integer)value);
                continue;
            }
            if (cls == Long.class || cls == Long.TYPE) {
                Array.setLong(o, index, (Long)value);
                continue;
            }
            if (cls == Float.class || cls == Float.TYPE) {
                Array.setFloat(o, index, ((Float)value).floatValue());
                continue;
            }
            if (cls == Double.class || cls == Double.TYPE) {
                Array.setDouble(o, index, (Double)value);
                continue;
            }
            if (cls == Boolean.class || cls == Boolean.TYPE) {
                Array.setBoolean(o, index, (Boolean)value);
                continue;
            }
            if (cls == Character.class || cls == Character.TYPE) {
                Array.setChar(o, index, ((Character)value).charValue());
                continue;
            }
            Array.set(o, index, value);
        }
        return o;
    }
}

