/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.serialization.mappers;

import dev.gigaherz.util.gddl2.serialization.GddlSerializer;
import dev.gigaherz.util.gddl2.structure.GddlElement;
import dev.gigaherz.util.gddl2.structure.GddlMap;

public abstract class MapperBase {
    int priority;

    public int getPriority() {
        return this.priority;
    }

    public MapperBase(int priority) {
        this.priority = priority;
    }

    protected GddlMap getTypeCompound(Object o, String type) {
        GddlMap tag = GddlMap.empty();
        tag.put("type", type);
        tag.put("className", o.getClass().getName());
        return tag;
    }

    protected GddlMap wrapToCompound(GddlElement<?> tag, Object o) {
        if (tag.isMap()) {
            return tag.asMap();
        }
        GddlMap tag2 = this.getTypeCompound(o, "custom");
        tag2.get("data");
        return tag2;
    }

    public abstract boolean canMapToField(Class<?> var1);

    public abstract boolean canMapToMap(Class<?> var1);

    public abstract void serializeField(GddlMap var1, String var2, Object var3, GddlSerializer var4) throws ReflectiveOperationException;

    public abstract Object deserializeField(GddlMap var1, String var2, Class<?> var3, GddlSerializer var4) throws ReflectiveOperationException;

    public abstract GddlMap serializeMap(Object var1, GddlSerializer var2) throws ReflectiveOperationException;

    public abstract Object deserializeMap(GddlMap var1, Class<?> var2, GddlSerializer var3) throws ReflectiveOperationException;
}

