/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.serialization.mappers;

import dev.gigaherz.util.gddl2.serialization.GddlSerializer;
import dev.gigaherz.util.gddl2.serialization.mappers.MapperBase;
import dev.gigaherz.util.gddl2.structure.GddlMap;
import java.lang.reflect.Type;

public class PrimitiveTypeMapper
extends MapperBase {
    public PrimitiveTypeMapper(int priority) {
        super(priority);
    }

    private static boolean isBoxType(Type type) {
        return type == Integer.class || type == Float.class || type == Byte.class || type == Double.class || type == Long.class || type == Character.class || type == Boolean.class || type == Short.class || type == Void.class;
    }

    @Override
    public boolean canMapToField(Class<?> clazz) {
        return clazz.isPrimitive() || PrimitiveTypeMapper.isBoxType(clazz);
    }

    @Override
    public boolean canMapToMap(Class<?> clazz) {
        return false;
    }

    @Override
    public void serializeField(GddlMap parent, String fieldName, Object object, GddlSerializer serializer) throws ReflectiveOperationException {
        if (object instanceof Byte) {
            Byte b = (Byte)object;
            parent.put(fieldName, b.byteValue());
        } else if (object instanceof Short) {
            Short s = (Short)object;
            parent.put(fieldName, s.shortValue());
        } else if (object instanceof Integer) {
            Integer i = (Integer)object;
            parent.put(fieldName, i.intValue());
        } else if (object instanceof Long) {
            Long l = (Long)object;
            parent.put(fieldName, l);
        } else if (object instanceof Float) {
            Float f = (Float)object;
            parent.put(fieldName, f.floatValue());
        } else if (object instanceof Double) {
            Double d = (Double)object;
            parent.put(fieldName, d);
        } else if (object instanceof Boolean) {
            Boolean b = (Boolean)object;
            parent.put(fieldName, b);
        } else if (object instanceof Character) {
            Character c = (Character)object;
            parent.put(fieldName, c.charValue());
        }
    }

    @Override
    public Object deserializeField(GddlMap parent, String fieldName, Class<?> clazz, GddlSerializer serializer) throws ReflectiveOperationException {
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return (byte)parent.get(fieldName).intValue();
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return (short)parent.get(fieldName).intValue();
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return (int)parent.get(fieldName).intValue();
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return parent.get(fieldName).intValue();
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return Float.valueOf((float)parent.get(fieldName).doubleValue());
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return parent.get(fieldName).doubleValue();
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return parent.get(fieldName).booleanValue();
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            return Character.valueOf((char)parent.get(fieldName).intValue());
        }
        return null;
    }

    @Override
    public GddlMap serializeMap(Object object, GddlSerializer serializer) throws ReflectiveOperationException {
        return null;
    }

    @Override
    public Object deserializeMap(GddlMap self, Class<?> clazz, GddlSerializer serializer) throws ReflectiveOperationException {
        return null;
    }
}

