/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public final class Utility {
    private static final int UE_QUOTE = 1;
    private static final int UE_ESCAPE = 2;
    private static final int UE_ESCAPE_LB = 3;
    private static final int UE_ESCAPE_HEX = 5;
    private static final int UE_ESCAPE_END = 6;
    private static final int NON_PRINTABLE = 909312;

    private Utility() {
        throw new IllegalStateException("This class is not instantiable.");
    }

    public static int upperPower(int n) {
        --n;
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return n + 1;
    }

    public static boolean isValidIdentifier(String text) {
        boolean first = true;
        for (char c : text.toCharArray()) {
            if (!(Utility.isLetter(c) || c == '_' || !first && Utility.isDigit(c))) {
                return false;
            }
            first = false;
        }
        return true;
    }

    public static String escapeString(String text) {
        return Utility.escapeString(text, '\"');
    }

    public static String escapeString(String text, char delimiter) {
        StringBuilder sb = new StringBuilder();
        sb.append(delimiter);
        block9: for (char c : text.toCharArray()) {
            if (Utility.isValidStringCharacter(c, delimiter)) {
                sb.append(c);
                continue;
            }
            sb.append('\\');
            switch (c) {
                case '\b': {
                    sb.append('b');
                    continue block9;
                }
                case '\t': {
                    sb.append('t');
                    continue block9;
                }
                case '\n': {
                    sb.append('n');
                    continue block9;
                }
                case '\f': {
                    sb.append('f');
                    continue block9;
                }
                case '\r': {
                    sb.append('r');
                    continue block9;
                }
                case '\"': {
                    sb.append('\"');
                    continue block9;
                }
                case '\\': {
                    sb.append('\\');
                    continue block9;
                }
                default: {
                    if (c > '\u00ff') {
                        sb.append(String.format("u%04x", c));
                        continue block9;
                    }
                    sb.append(String.format("x%02x", c));
                }
            }
        }
        sb.append(delimiter);
        return sb.toString();
    }

    public static boolean isValidStringCharacter(char c, char delimiter) {
        return Utility.isPrintable(c) && !Utility.isControl(c) && c != delimiter && c != '\\';
    }

    public static String unescapeString(String text) {
        StringBuilder sb = new StringBuilder();
        char startQuote = '\u0000';
        int state = 1;
        int escapeAcc = 0;
        int escapeDigits = 0;
        int escapeMax = 0;
        block18: for (char c : text.toCharArray()) {
            if (startQuote != '\u0000') {
                if (state == 5) {
                    if (escapeDigits == escapeMax) {
                        sb.append((char)escapeAcc);
                        state = 1;
                    } else if (Utility.isDigit(c)) {
                        escapeAcc = (escapeAcc << 4) + (c - 48);
                    } else if (escapeDigits < escapeMax && c >= 'a' && c <= 'f') {
                        escapeAcc = (escapeAcc << 4) + 10 + (c - 97);
                    } else if (escapeDigits < escapeMax && c >= 'A' && c <= 'F') {
                        escapeAcc = (escapeAcc << 4) + 10 + (c - 65);
                    } else {
                        sb.append((char)escapeAcc);
                        state = 1;
                    }
                    ++escapeDigits;
                }
                if (state == 3) {
                    if (c == '\n') {
                        sb.append('\n');
                        state = 6;
                    } else {
                        state = 1;
                    }
                } else if (state == 6) {
                    state = 1;
                }
                if (state == 2) {
                    switch (c) {
                        case '\"': {
                            sb.append('\"');
                            state = 6;
                            break;
                        }
                        case '\'': {
                            sb.append('\'');
                            state = 6;
                            break;
                        }
                        case '\\': {
                            sb.append('\\');
                            state = 6;
                            break;
                        }
                        case '0': {
                            sb.append('\u0000');
                            state = 6;
                            break;
                        }
                        case 'b': {
                            sb.append('\b');
                            state = 6;
                            break;
                        }
                        case 't': {
                            sb.append('\t');
                            state = 6;
                            break;
                        }
                        case 'f': {
                            sb.append('\f');
                            state = 6;
                            break;
                        }
                        case 'r': {
                            sb.append('\r');
                            state = 6;
                            break;
                        }
                        case '\n': 
                        case 'n': {
                            sb.append('\n');
                            state = 6;
                            break;
                        }
                        case '\r': {
                            sb.append('\r');
                            state = 3;
                            break;
                        }
                        case 'x': {
                            state = 5;
                            escapeAcc = 0;
                            escapeDigits = 0;
                            escapeMax = 2;
                            break;
                        }
                        case 'u': {
                            state = 5;
                            escapeAcc = 0;
                            escapeDigits = 0;
                            escapeMax = 4;
                        }
                    }
                }
                if (state != 1) continue;
                if (c == startQuote) {
                    return sb.toString();
                }
                if (c == '\\') {
                    state = 2;
                    continue;
                }
                sb.append(c);
                continue;
            }
            switch (c) {
                case '\"': {
                    startQuote = '\"';
                    continue block18;
                }
                case '\'': {
                    startQuote = '\'';
                    continue block18;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        throw new IllegalArgumentException("Invalid string literal");
    }

    public static boolean isPrintable(char c) {
        return (909312 >> Character.getType(c) & 1) == 0;
    }

    public static boolean isLetter(int c) {
        return Character.isLetter(c);
    }

    public static boolean isDigit(int c) {
        return Character.isDigit(c);
    }

    public static boolean isControl(int c) {
        return Character.isISOControl(c);
    }

    public static <T> String join(CharSequence separator, T[] elements) {
        return Utility.join(separator, Arrays.stream(elements));
    }

    public static <T> String join(CharSequence separator, Stream<T> stream) {
        return Utility.join(separator, stream.iterator());
    }

    public static <T> String join(CharSequence separator, Iterator<T> iterator) {
        StringJoiner joiner = new StringJoiner(separator);
        while (iterator.hasNext()) {
            T e = iterator.next();
            joiner.add(e.toString());
        }
        return joiner.toString();
    }

    public static boolean isNullOrEmpty(@Nullable String string) {
        return string == null || string.length() == 0;
    }

    public static <T> boolean listEquals(List<T> a, List<T> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (Objects.equals(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }
}

