/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.serialization.mappers;

import dev.gigaherz.util.gddl2.serialization.GddlSerializer;
import dev.gigaherz.util.gddl2.serialization.mappers.MapperBase;
import dev.gigaherz.util.gddl2.structure.GddlElement;
import dev.gigaherz.util.gddl2.structure.GddlMap;
import dev.gigaherz.util.gddl2.structure.GddlValue;
import java.lang.reflect.Type;

public class PrimitiveTypeMapper
extends MapperBase {
    public PrimitiveTypeMapper(int priority) {
        super(priority);
    }

    private static boolean isBoxType(Type type) {
        return type == Integer.class || type == Float.class || type == Byte.class || type == Double.class || type == Long.class || type == Character.class || type == Boolean.class || type == Short.class || type == Void.class;
    }

    @Override
    public boolean canApply(Class<?> clazz) {
        return clazz.isPrimitive() || PrimitiveTypeMapper.isBoxType(clazz);
    }

    @Override
    public GddlElement<?> serialize(Object object, GddlSerializer serializer) throws ReflectiveOperationException {
        if (object instanceof Byte) {
            Byte b = (Byte)object;
            return GddlValue.of(b.byteValue());
        }
        if (object instanceof Short) {
            Short s = (Short)object;
            return GddlValue.of(s.shortValue());
        }
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            return GddlValue.of(i.intValue());
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            return GddlValue.of(l);
        }
        if (object instanceof Float) {
            Float f = (Float)object;
            return GddlValue.of(f.floatValue());
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            return GddlValue.of(d);
        }
        if (object instanceof Boolean) {
            Boolean b = (Boolean)object;
            return GddlValue.of(b);
        }
        if (object instanceof Character) {
            Character c = (Character)object;
            return GddlValue.of(c.charValue());
        }
        throw new IllegalStateException("Class is not a java primitive!");
    }

    @Override
    public GddlElement<?> serializeVerbose(Object object, GddlSerializer serializer) throws ReflectiveOperationException {
        return this.wrapVerbose(object, this.serialize(object, serializer));
    }

    @Override
    public Object deserialize(GddlElement<?> element, Class<?> clazz, GddlSerializer serializer) throws ReflectiveOperationException {
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return element.byteValue();
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return element.shortValue();
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return element.intValue();
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return element.longValue();
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return Float.valueOf(element.floatValue());
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return element.doubleValue();
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return element.booleanValue();
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            return Character.valueOf((char)element.intValue());
        }
        return null;
    }

    @Override
    public Object deserializeVerbose(GddlMap map, Class<?> clazz, GddlSerializer serializer) throws ReflectiveOperationException {
        return this.deserialize(this.unwrapVerbose(map), clazz, serializer);
    }
}

