/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.structure;

import dev.gigaherz.util.gddl2.structure.GddlElement;
import dev.gigaherz.util.gddl2.structure.GddlList;
import dev.gigaherz.util.gddl2.structure.GddlValue;
import dev.gigaherz.util.gddl2.util.Utility;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class GddlMap
extends GddlElement<GddlMap>
implements Map<String, GddlElement<?>> {
    private final Map<String, GddlElement<?>> contents = new LinkedHashMap();
    private final Map<String, GddlElement<?>> contentsView = Collections.unmodifiableMap(this.contents);
    private String trailingComment;
    private String typeName;

    public static GddlMap empty() {
        return new GddlMap();
    }

    public static GddlMap of(String key, GddlElement<?> value) {
        return new GddlMap(List.of(Map.entry(key, value)));
    }

    public static GddlMap of(String key, GddlElement<?> value, String key2, GddlElement<?> value2) {
        return new GddlMap(List.of(Map.entry(key, value), Map.entry(key2, value2)));
    }

    public static GddlMap of(String key, GddlElement<?> value, String key2, GddlElement<?> value2, String key3, GddlElement<?> value3) {
        return new GddlMap(List.of(Map.entry(key, value), Map.entry(key2, value2), Map.entry(key3, value3)));
    }

    public static GddlMap of(String key, GddlElement<?> value, String key2, GddlElement<?> value2, String key3, GddlElement<?> value3, String key4, GddlElement<?> value4) {
        return new GddlMap(List.of(Map.entry(key, value), Map.entry(key2, value2), Map.entry(key3, value3), Map.entry(key4, value4)));
    }

    @SafeVarargs
    public static GddlMap of(Map.Entry<String, GddlElement<?>> ... values) {
        return new GddlMap(Arrays.asList(values));
    }

    public static GddlMap of(Collection<Map.Entry<String, GddlElement<?>>> values) {
        return new GddlMap(values);
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public GddlMap asMap() {
        return this;
    }

    public boolean hasTrailingComment() {
        return !Utility.isNullOrEmpty(this.trailingComment);
    }

    public String getTrailingComment() {
        return this.trailingComment;
    }

    public void setTrailingComment(String trailingComment) {
        this.trailingComment = trailingComment;
    }

    public boolean hasTypeName() {
        return !Utility.isNullOrEmpty(this.typeName);
    }

    public String getTypeName() {
        return this.typeName;
    }

    @NotNull
    public GddlMap withTypeName(String value) {
        if (!Utility.isValidIdentifier(value)) {
            throw new IllegalArgumentException("Type value must be a valid identifier");
        }
        this.typeName = value;
        return this;
    }

    @NotNull
    public Optional<GddlElement<?>> find(String name) {
        return Optional.ofNullable(this.contents.get(name));
    }

    @Override
    public GddlElement<?> put(String key, GddlElement<?> value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        GddlElement<?> previous = this.contents.put(key, value);
        this.onAdd(value);
        if (previous != null && previous != value) {
            this.onRemove(previous);
        }
        return previous;
    }

    @Override
    public GddlElement<?> put(String key, String value) {
        return this.put(key, GddlValue.of(value));
    }

    @Override
    public GddlElement<?> put(String key, long value) {
        return this.put(key, GddlValue.of(value));
    }

    @Override
    public GddlElement<?> put(String key, boolean value) {
        return this.put(key, GddlValue.of(value));
    }

    @Override
    public GddlElement<?> put(String key, double value) {
        return this.put(key, GddlValue.of(value));
    }

    @Override
    public void putAll(@NotNull Map<? extends String, ? extends GddlElement<?>> m) {
        for (Map.Entry<String, GddlElement<?>> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public GddlElement<?> remove(String key) {
        GddlElement<?> e = this.contents.remove(key);
        if (e != null) {
            this.onRemove(e);
        }
        return e;
    }

    public boolean remove(String key, GddlElement<?> e) {
        boolean r = this.contents.remove(key, e);
        if (r) {
            this.onRemove(e);
        }
        return r;
    }

    public boolean containsKey(String key) {
        return this.contents.containsKey(key);
    }

    public boolean containsValue(GddlElement<?> element) {
        return this.contents.containsValue(element);
    }

    public GddlElement<?> get(String key) {
        return this.contents.get(key);
    }

    public GddlMap getMap(String key) {
        return this.get(key).asMap();
    }

    public GddlList getList(String key) {
        return this.get(key).asList();
    }

    public String getString(String key) {
        return this.get(key).stringValue();
    }

    public byte getByte(String key) {
        return this.get(key).byteValue();
    }

    public short getShort(String key) {
        return this.get(key).shortValue();
    }

    public int getInt(String key) {
        return this.get(key).intValue();
    }

    public long getLong(String key) {
        return this.get(key).longValue();
    }

    public float getFloat(String key) {
        return this.get(key).floatValue();
    }

    public double getDouble(String key) {
        return this.get(key).doubleValue();
    }

    public boolean getBoolean(String key) {
        return this.get(key).booleanValue();
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    @Override
    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    @Override
    public void clear() {
        this.contents.values().forEach(this::onRemove);
        this.contents.clear();
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        return this.contents.keySet();
    }

    @Override
    @NotNull
    public Collection<GddlElement<?>> values() {
        return this.contents.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, GddlElement<?>>> entrySet() {
        return this.contentsView.entrySet();
    }

    @Override
    public int getFormattingComplexity() {
        return 2 + this.contents.values().stream().mapToInt(i -> 3 * i.getFormattingComplexity()).sum();
    }

    public Stream<String> keysOf(GddlElement<?> value) {
        return this.contents.entrySet().stream().filter(kv -> kv.getValue() == value).map(Map.Entry::getKey);
    }

    private GddlMap() {
    }

    private GddlMap(Collection<Map.Entry<String, GddlElement<?>>> entries) {
        for (Map.Entry<String, GddlElement<?>> entry : entries) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    private void onAdd(GddlElement<?> e) {
        e.setParent(this);
    }

    private void onRemove(GddlElement<?> e) {
        e.setParent(null);
    }

    @Override
    @Deprecated
    public boolean containsKey(Object key) {
        return this.contents.containsKey(key);
    }

    @Override
    @Deprecated
    public boolean containsValue(Object value) {
        return this.contents.containsValue(value);
    }

    @Override
    @Deprecated
    public GddlElement<?> get(Object key) {
        GddlElement<?> gddlElement;
        if (key instanceof String) {
            String s = (String)key;
            gddlElement = this.get(s);
        } else {
            gddlElement = null;
        }
        return gddlElement;
    }

    @Override
    @Deprecated
    public GddlElement<?> remove(Object key) {
        GddlElement<?> gddlElement;
        if (key instanceof String) {
            String s = (String)key;
            gddlElement = this.remove(s);
        } else {
            gddlElement = null;
        }
        return gddlElement;
    }

    @Override
    protected GddlMap copyInternal() {
        GddlMap collection = new GddlMap();
        this.copyTo(collection);
        return collection;
    }

    @Override
    protected void copyTo(GddlMap other) {
        super.copyTo(other);
        for (Map.Entry<String, GddlElement<?>> e : this.contents.entrySet()) {
            other.put(e.getKey(), (GddlElement<?>)e.getValue().copy());
        }
    }

    @Override
    public void resolve(GddlElement<?> root) {
        for (GddlElement<?> el : this.contents.values()) {
            el.resolve(root);
        }
    }

    public GddlMap simplify() {
        for (Map.Entry<String, GddlElement<?>> entry : this.contents.entrySet()) {
            this.put(entry.getKey(), entry.getValue().simplify());
        }
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.equalsImpl((GddlMap)other);
    }

    @Override
    public boolean equals(GddlMap other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.equalsImpl(other);
    }

    public boolean equalsImpl(@NotNull GddlMap other) {
        return this.contents.equals(other.contents) && Objects.equals(this.typeName, other.typeName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.contents, this.typeName);
    }
}

