/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.structure;

import dev.gigaherz.util.gddl2.structure.GddlElement;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class GddlValue
extends GddlElement<GddlValue> {
    private Object data;

    public static GddlValue nullValue() {
        return new GddlValue();
    }

    public static GddlValue of(boolean value) {
        return new GddlValue(value);
    }

    public static GddlValue of(long num) {
        return new GddlValue(num);
    }

    public static GddlValue of(double num) {
        return new GddlValue(num);
    }

    public static GddlValue of(String s) {
        return new GddlValue(s);
    }

    @Override
    public boolean isValue() {
        return true;
    }

    @Override
    public GddlValue asValue() {
        return this;
    }

    @Override
    public String stringValue() {
        return (String)Objects.requireNonNull(this.data);
    }

    @Override
    public boolean booleanValue() {
        return (Boolean)Objects.requireNonNull(this.data);
    }

    @Override
    public byte byteValue() {
        return (byte)this.longValue();
    }

    @Override
    public short shortValue() {
        return (short)this.longValue();
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public long longValue() {
        return (Long)Objects.requireNonNull(this.data);
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public double doubleValue() {
        return (Double)Objects.requireNonNull(this.data);
    }

    @Override
    public boolean isNull() {
        return this.data == null;
    }

    @Override
    public boolean isBoolean() {
        return this.data instanceof Boolean;
    }

    @Override
    public boolean isInteger() {
        return this.data instanceof Long;
    }

    @Override
    public boolean isDouble() {
        return this.data instanceof Double;
    }

    @Override
    public boolean isString() {
        return this.data instanceof String;
    }

    private GddlValue() {
        this.data = null;
    }

    private GddlValue(boolean valueData) {
        this.data = valueData;
    }

    private GddlValue(String valueData) {
        this.data = valueData;
    }

    private GddlValue(long valueData) {
        this.data = valueData;
    }

    private GddlValue(double valueData) {
        this.data = valueData;
    }

    @Override
    protected GddlValue copyInternal() {
        GddlValue value = new GddlValue();
        this.copyTo(value);
        return value;
    }

    @Override
    protected void copyTo(GddlValue other) {
        super.copyTo(other);
        other.data = this.data;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.equalsImpl((GddlValue)other);
    }

    @Override
    public boolean equals(GddlValue other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.equalsImpl(other);
    }

    private boolean equalsImpl(@NotNull GddlValue value) {
        return Objects.equals(this.data, value.data);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.data);
    }
}

