/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.formatting;

import dev.gigaherz.util.gddl2.formatting.DoubleFormattingStyle;

public final class FormatterOptions {
    public static final FormatterOptions COMPACT_HUMAN = new Builder().build();
    public static final FormatterOptions NICE_HUMAN = new Builder().writeComments(true).lineBreaksAfterOpeningBrace(1).lineBreaksBeforeClosingBrace(1).lineBreaksAfterClosingBrace(1).lineBreaksAfterValues(1).spacesBeforeOpeningBrace(0).spacesAfterOpeningBrace(1).spacesBeforeClosingBrace(1).spacesAfterClosingBrace(0).spacesInEmptyCollection(1).spacesAfterComma(1).spacesBeforeEquals(1).spacesAfterEquals(1).spacesInEmptyCollection(1).oneElementPerLineThreshold(10).spacesPerIndent(4).blankLinesBeforeComment(1).build();
    public static final FormatterOptions COMPACT_JSON = new Builder(COMPACT_HUMAN).alwaysUseStringLiterals(true).useJsonDelimiters(true).build();
    public static final FormatterOptions NICE_JSON = new Builder(NICE_HUMAN).spacesBeforeEquals(0).alwaysUseStringLiterals(true).useJsonDelimiters(true).build();
    public static final FormatterOptions COMPACT_JSON5 = new Builder(COMPACT_JSON).alwaysUseStringLiterals(false).build();
    public static final FormatterOptions NICE_JSON5 = new Builder(NICE_JSON).alwaysUseStringLiterals(false).build();
    public final int lineBreaksBeforeOpeningBrace;
    public final int lineBreaksAfterOpeningBrace;
    public final int lineBreaksBeforeClosingBrace;
    public final int lineBreaksAfterClosingBrace;
    public final int spacesBeforeOpeningBrace;
    public final int spacesAfterOpeningBrace;
    public final int spacesBeforeClosingBrace;
    public final int spacesAfterClosingBrace;
    public final int spacesBeforeComma;
    public final int spacesAfterComma;
    public final int spacesBeforeEquals;
    public final int spacesAfterEquals;
    public final int spacesInEmptyCollection;
    public final int oneElementPerLineThreshold;
    public final boolean omitCommaAfterClosingBrace;
    public final boolean sortMapKeys;
    public final boolean alwaysUseStringLiterals;
    public final int lineBreaksAfterValues;
    public final DoubleFormattingStyle floatFormattingStyle;
    public final boolean alwaysShowNumberSign;
    public final boolean alwaysShowExponentSign;
    public final int autoScientificNotationUpper;
    public final int autoScientificNotationLower;
    public final int floatSignificantFigures;
    public final boolean indentUsingTabs;
    public final int spacesPerIndent;
    public final boolean writeComments;
    public final int blankLinesBeforeComment;
    public final boolean trimCommentLines;
    public final boolean useJsonDelimiters;

    private FormatterOptions(Builder builder) {
        this.lineBreaksBeforeOpeningBrace = builder.lineBreaksBeforeOpeningBrace;
        this.lineBreaksAfterOpeningBrace = builder.lineBreaksAfterOpeningBrace;
        this.lineBreaksBeforeClosingBrace = builder.lineBreaksBeforeClosingBrace;
        this.lineBreaksAfterClosingBrace = builder.lineBreaksAfterClosingBrace;
        this.spacesBeforeOpeningBrace = builder.spacesBeforeOpeningBrace;
        this.spacesAfterOpeningBrace = builder.spacesAfterOpeningBrace;
        this.spacesBeforeClosingBrace = builder.spacesBeforeClosingBrace;
        this.spacesAfterClosingBrace = builder.spacesAfterClosingBrace;
        this.spacesBeforeComma = builder.spacesBeforeComma;
        this.spacesAfterComma = builder.spacesAfterComma;
        this.spacesBeforeEquals = builder.spacesBeforeEquals;
        this.spacesAfterEquals = builder.spacesAfterEquals;
        this.spacesInEmptyCollection = builder.spacesInEmptyCollection;
        this.oneElementPerLineThreshold = builder.oneElementPerLineThreshold;
        this.omitCommaAfterClosingBrace = builder.omitCommaAfterClosingBrace;
        this.sortMapKeys = builder.sortMapKeys;
        this.lineBreaksAfterValues = builder.lineBreaksAfterValues;
        this.floatFormattingStyle = builder.floatFormattingStyle;
        this.alwaysShowNumberSign = builder.alwaysShowNumberSign;
        this.alwaysShowExponentSign = builder.alwaysShowExponentSign;
        this.autoScientificNotationUpper = builder.autoScientificNotationUpper;
        this.autoScientificNotationLower = builder.autoScientificNotationLower;
        this.floatSignificantFigures = builder.floatSignificantFigures;
        this.indentUsingTabs = builder.indentUsingTabs;
        this.spacesPerIndent = builder.spacesPerIndent;
        this.writeComments = builder.writeComments;
        this.blankLinesBeforeComment = builder.blankLinesBeforeComment;
        this.trimCommentLines = builder.trimCommentLines;
        this.useJsonDelimiters = builder.useJsonDelimiters;
        this.alwaysUseStringLiterals = builder.alwaysUseStringLiterals;
    }

    public static final class Builder {
        private int lineBreaksBeforeOpeningBrace = 0;
        private int lineBreaksAfterOpeningBrace = 0;
        private int lineBreaksBeforeClosingBrace = 0;
        private int lineBreaksAfterClosingBrace = 0;
        private int spacesBeforeOpeningBrace = 0;
        private int spacesAfterOpeningBrace = 0;
        private int spacesBeforeClosingBrace = 0;
        private int spacesAfterClosingBrace = 0;
        private int spacesBeforeComma = 0;
        private int spacesAfterComma = 0;
        private int spacesBeforeEquals = 0;
        private int spacesAfterEquals = 0;
        private int spacesInEmptyCollection = 0;
        private int oneElementPerLineThreshold = Integer.MAX_VALUE;
        private boolean omitCommaAfterClosingBrace = false;
        private boolean sortMapKeys = false;
        private boolean alwaysUseStringLiterals = false;
        private int lineBreaksAfterValues = 0;
        private DoubleFormattingStyle floatFormattingStyle = DoubleFormattingStyle.AUTO;
        private boolean alwaysShowNumberSign = false;
        private boolean alwaysShowExponentSign = false;
        private int autoScientificNotationUpper = 5;
        private int autoScientificNotationLower = -2;
        private int floatSignificantFigures = 15;
        private boolean indentUsingTabs = false;
        private int spacesPerIndent = 2;
        private boolean writeComments = false;
        private int blankLinesBeforeComment = 0;
        private boolean trimCommentLines = true;
        private boolean useJsonDelimiters = false;

        public Builder() {
        }

        public Builder(FormatterOptions copyFrom) {
            this.lineBreaksBeforeOpeningBrace = copyFrom.lineBreaksBeforeOpeningBrace;
            this.lineBreaksAfterOpeningBrace = copyFrom.lineBreaksAfterOpeningBrace;
            this.lineBreaksBeforeClosingBrace = copyFrom.lineBreaksBeforeClosingBrace;
            this.lineBreaksAfterClosingBrace = copyFrom.lineBreaksAfterClosingBrace;
            this.spacesBeforeOpeningBrace = copyFrom.spacesBeforeOpeningBrace;
            this.spacesAfterOpeningBrace = copyFrom.spacesAfterOpeningBrace;
            this.spacesBeforeClosingBrace = copyFrom.spacesBeforeClosingBrace;
            this.spacesAfterClosingBrace = copyFrom.spacesAfterClosingBrace;
            this.spacesBeforeComma = copyFrom.spacesBeforeComma;
            this.spacesAfterComma = copyFrom.spacesAfterComma;
            this.spacesBeforeEquals = copyFrom.spacesBeforeEquals;
            this.spacesAfterEquals = copyFrom.spacesAfterEquals;
            this.spacesInEmptyCollection = copyFrom.spacesInEmptyCollection;
            this.oneElementPerLineThreshold = copyFrom.oneElementPerLineThreshold;
            this.omitCommaAfterClosingBrace = copyFrom.omitCommaAfterClosingBrace;
            this.sortMapKeys = copyFrom.sortMapKeys;
            this.lineBreaksAfterValues = copyFrom.lineBreaksAfterValues;
            this.floatFormattingStyle = copyFrom.floatFormattingStyle;
            this.alwaysShowNumberSign = copyFrom.alwaysShowNumberSign;
            this.alwaysShowExponentSign = copyFrom.alwaysShowExponentSign;
            this.autoScientificNotationUpper = copyFrom.autoScientificNotationUpper;
            this.autoScientificNotationLower = copyFrom.autoScientificNotationLower;
            this.floatSignificantFigures = copyFrom.floatSignificantFigures;
            this.indentUsingTabs = copyFrom.indentUsingTabs;
            this.spacesPerIndent = copyFrom.spacesPerIndent;
            this.writeComments = copyFrom.writeComments;
            this.blankLinesBeforeComment = copyFrom.blankLinesBeforeComment;
            this.trimCommentLines = copyFrom.trimCommentLines;
            this.useJsonDelimiters = copyFrom.useJsonDelimiters;
        }

        public Builder lineBreaksBeforeOpeningBrace(int lineBreaksBeforeOpeningBrace) {
            this.lineBreaksBeforeOpeningBrace = lineBreaksBeforeOpeningBrace;
            return this;
        }

        public Builder lineBreaksAfterOpeningBrace(int lineBreaksAfterOpeningBrace) {
            this.lineBreaksAfterOpeningBrace = lineBreaksAfterOpeningBrace;
            return this;
        }

        public Builder lineBreaksBeforeClosingBrace(int lineBreaksBeforeClosingBrace) {
            this.lineBreaksBeforeClosingBrace = lineBreaksBeforeClosingBrace;
            return this;
        }

        public Builder lineBreaksAfterClosingBrace(int lineBreaksAfterClosingBrace) {
            this.lineBreaksAfterClosingBrace = lineBreaksAfterClosingBrace;
            return this;
        }

        public Builder spacesBeforeOpeningBrace(int spacesBeforeOpeningBrace) {
            this.spacesBeforeOpeningBrace = spacesBeforeOpeningBrace;
            return this;
        }

        public Builder spacesAfterOpeningBrace(int spacesAfterOpeningBrace) {
            this.spacesAfterOpeningBrace = spacesAfterOpeningBrace;
            return this;
        }

        public Builder spacesBeforeClosingBrace(int spacesBeforeClosingBrace) {
            this.spacesBeforeClosingBrace = spacesBeforeClosingBrace;
            return this;
        }

        public Builder spacesAfterClosingBrace(int spacesAfterClosingBrace) {
            this.spacesAfterClosingBrace = spacesAfterClosingBrace;
            return this;
        }

        public Builder spacesBeforeComma(int spacesBeforeComma) {
            this.spacesBeforeComma = spacesBeforeComma;
            return this;
        }

        public Builder spacesAfterComma(int spacesAfterComma) {
            this.spacesAfterComma = spacesAfterComma;
            return this;
        }

        public Builder spacesBeforeEquals(int spacesBeforeEquals) {
            this.spacesBeforeEquals = spacesBeforeEquals;
            return this;
        }

        public Builder spacesAfterEquals(int spacesAfterEquals) {
            this.spacesAfterEquals = spacesAfterEquals;
            return this;
        }

        public Builder spacesInEmptyCollection(int spacesInEmptyCollection) {
            this.spacesInEmptyCollection = spacesInEmptyCollection;
            return this;
        }

        public Builder oneElementPerLineThreshold(int oneElementPerLineThreshold) {
            this.oneElementPerLineThreshold = oneElementPerLineThreshold;
            return this;
        }

        public Builder omitCommaAfterClosingBrace(boolean omitCommaAfterClosingBrace) {
            this.omitCommaAfterClosingBrace = omitCommaAfterClosingBrace;
            return this;
        }

        public Builder sortMapKeys(boolean sortMapKeys) {
            this.sortMapKeys = sortMapKeys;
            return this;
        }

        public Builder lineBreaksAfterValues(int lineBreaksAfterValues) {
            this.lineBreaksAfterValues = lineBreaksAfterValues;
            return this;
        }

        public Builder floatFormattingStyle(DoubleFormattingStyle floatFormattingStyle) {
            this.floatFormattingStyle = floatFormattingStyle;
            return this;
        }

        public Builder alwaysShowNumberSign(boolean alwaysShowNumberSign) {
            this.alwaysShowNumberSign = alwaysShowNumberSign;
            return this;
        }

        public Builder alwaysShowExponentSign(boolean alwaysShowExponentSign) {
            this.alwaysShowExponentSign = alwaysShowExponentSign;
            return this;
        }

        public Builder autoScientificNotationUpper(int autoScientificNotationUpper) {
            this.autoScientificNotationUpper = autoScientificNotationUpper;
            return this;
        }

        public Builder autoScientificNotationLower(int autoScientificNotationLower) {
            this.autoScientificNotationLower = autoScientificNotationLower;
            return this;
        }

        public Builder floatSignificantFigures(int floatSignificantFigures) {
            this.floatSignificantFigures = floatSignificantFigures;
            return this;
        }

        public Builder indentUsingTabs(boolean indentUsingTabs) {
            this.indentUsingTabs = indentUsingTabs;
            return this;
        }

        public Builder spacesPerIndent(int spacesPerIndent) {
            this.spacesPerIndent = spacesPerIndent;
            return this;
        }

        public Builder writeComments(boolean writeComments) {
            this.writeComments = writeComments;
            return this;
        }

        public Builder blankLinesBeforeComment(int blankLinesBeforeComment) {
            this.blankLinesBeforeComment = blankLinesBeforeComment;
            return this;
        }

        public Builder trimCommentLines(boolean trimCommentLines) {
            this.trimCommentLines = trimCommentLines;
            return this;
        }

        public Builder useJsonDelimiters(boolean prefer) {
            this.useJsonDelimiters = prefer;
            return this;
        }

        public Builder alwaysUseStringLiterals(boolean alwaysUseStringLiterals) {
            this.alwaysUseStringLiterals = alwaysUseStringLiterals;
            return this;
        }

        public FormatterOptions build() {
            return new FormatterOptions(this);
        }
    }
}

