/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.internal;

import dev.gigaherz.util.gddl2.internal.Utility;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ArrayQueue<T> {
    private static final int defaultCapacity = 16;
    private int capacityMask;
    private int start;
    private int count;
    private T[] buffer;

    public ArrayQueue() {
        this(16);
    }

    public ArrayQueue(int capacity) {
        if (capacity < 0) {
            throw new IndexOutOfBoundsException("capacity is less than 0.");
        }
        this.growTo(capacity);
    }

    private void growTo(int value) {
        value = Utility.upperPower(value);
        if (null != this.buffer && value == this.buffer.length) {
            return;
        }
        Object[] newBuffer = new Object[value];
        for (int i = 0; i < this.size(); ++i) {
            newBuffer[i] = this.get(i);
        }
        this.buffer = newBuffer;
        this.start = 0;
        this.capacityMask = value - 1;
    }

    private void ensureCapacityFor(int numElements) {
        if (this.size() + numElements > this.buffer.length) {
            this.growTo(this.size() + numElements);
        }
    }

    private int toBufferIndex(int index) {
        return index + this.start & this.capacityMask;
    }

    public int size() {
        return this.count;
    }

    public void add(T item) {
        this.ensureCapacityFor(1);
        this.buffer[this.toBufferIndex((int)this.size())] = item;
        ++this.count;
    }

    public T remove() {
        if (this.size() == 0) {
            throw new IllegalStateException("The Deque is empty");
        }
        T result = this.buffer[this.start];
        this.buffer[this.start] = null;
        this.start = this.toBufferIndex(1);
        --this.count;
        return result;
    }

    public T get(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[this.toBufferIndex(index)];
    }

    @NotNull
    public Stream<T> elements() {
        return IntStream.range(0, this.count).mapToObj(i -> this.get(i % this.count));
    }
}

