/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.parsing;

import dev.gigaherz.util.gddl2.exceptions.ReaderException;
import dev.gigaherz.util.gddl2.internal.ArrayQueue;
import dev.gigaherz.util.gddl2.internal.Utility;
import dev.gigaherz.util.gddl2.parsing.ContextProvider;
import dev.gigaherz.util.gddl2.parsing.ParsingContext;
import java.io.IOException;

public class Reader
implements ContextProvider,
AutoCloseable {
    private final ArrayQueue<Integer> lookAhead = new ArrayQueue();
    private final java.io.Reader dataSource;
    private final String sourceName;
    private boolean endQueued = false;
    private int line = 1;
    private int column = 1;
    private int lastEol;

    public Reader(java.io.Reader reader, String sourceName) {
        this.sourceName = sourceName;
        this.dataSource = reader;
    }

    public int peek() throws ReaderException, IOException {
        return this.peek(0);
    }

    public int peek(int index) throws ReaderException, IOException {
        this.require(index + 1);
        return this.lookAhead.get(index);
    }

    public String read(int count) throws ReaderException, IOException {
        this.require(count);
        StringBuilder b = new StringBuilder();
        while (count-- > 0) {
            int ch = this.nextInternal();
            if (ch < 0) {
                throw new ReaderException(this, "Tried to read beyond the end of the file.");
            }
            b.append((char)ch);
        }
        return b.toString();
    }

    public void skip(int count) throws ReaderException, IOException {
        this.require(count);
        while (count-- > 0) {
            this.nextInternal();
        }
    }

    private void require(int number) throws ReaderException, IOException {
        int needed = number - this.lookAhead.size();
        if (needed > 0) {
            this.needChars(needed);
        }
    }

    private void needChars(int needed) throws ReaderException, IOException {
        while (needed-- > 0) {
            if (this.endQueued) {
                throw new ReaderException(this, "Tried to read beyond the end of the file.");
            }
            int ch = this.dataSource.read();
            this.lookAhead.add(ch);
            if (ch >= 0) continue;
            this.endQueued = true;
        }
    }

    private int nextInternal() {
        int ch = this.lookAhead.remove();
        ++this.column;
        if (ch == 10) {
            this.column = 1;
            if (this.lastEol != 13) {
                ++this.line;
            }
            this.lastEol = ch;
        } else if (ch == 13) {
            this.column = 1;
            ++this.line;
            this.lastEol = ch;
        } else if (this.lastEol > 0) {
            this.lastEol = 0;
        }
        return ch;
    }

    public String toString() {
        return String.format("{Reader ahead=%s}", Utility.join((CharSequence)"", this.lookAhead.elements()));
    }

    @Override
    public ParsingContext getParsingContext() {
        return new ParsingContext(this.sourceName, this.line, this.column);
    }

    @Override
    public void close() throws IOException {
        this.dataSource.close();
    }
}

