/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.parsing;

import dev.gigaherz.util.gddl2.parsing.ContextProvider;
import dev.gigaherz.util.gddl2.parsing.ParsingContext;
import dev.gigaherz.util.gddl2.parsing.TokenType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class Token
implements ContextProvider {
    public final String whitespace;
    public final String comment;
    public final TokenType type;
    public final String text;
    public final ParsingContext context;
    public Token parent;

    public Token(TokenType type, String text, ContextProvider contextProvider, String comment, String whitespace) {
        this.whitespace = whitespace;
        this.comment = comment;
        this.type = type;
        this.text = text;
        this.context = contextProvider.getParsingContext();
    }

    public Token withParent(Token parent) {
        this.parent = parent;
        return this;
    }

    public Token specialize(TokenType child) {
        return new Token(child, this.text, this, this.comment, this.whitespace).withParent(this);
    }

    public String toString() {
        if (this.text == null) {
            return String.format("(%s @ %d:%d)", new Object[]{this.type, this.context.line, this.context.column});
        }
        if (this.text.length() > 22) {
            return String.format("(%s @ %d:%d: %s...)", new Object[]{this.type, this.context.line, this.context.column, this.text.substring(0, 20)});
        }
        return String.format("(%s @ %d:%d: %s)", new Object[]{this.type, this.context.line, this.context.column, this.text});
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.equalsImpl((Token)other);
    }

    public boolean equals(Token other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.equalsImpl(other);
    }

    private boolean equalsImpl(@NotNull Token other) {
        return this.type == other.type && this.text.equals(other.text) && this.context.equals(other.context);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.whitespace, this.comment, this.type, this.text, this.context});
    }

    public boolean is(TokenType tokenType) {
        return this.type == tokenType || this.parent != null && this.parent.is(tokenType);
    }

    @Override
    public ParsingContext getParsingContext() {
        return this.context;
    }
}

