/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.serialization;

import dev.gigaherz.util.gddl2.serialization.mappers.ArrayMapper;
import dev.gigaherz.util.gddl2.serialization.mappers.EnumMapper;
import dev.gigaherz.util.gddl2.serialization.mappers.GenericObjectMapper;
import dev.gigaherz.util.gddl2.serialization.mappers.ListMapper;
import dev.gigaherz.util.gddl2.serialization.mappers.MapMapper;
import dev.gigaherz.util.gddl2.serialization.mappers.Mapper;
import dev.gigaherz.util.gddl2.serialization.mappers.PassthroughMapper;
import dev.gigaherz.util.gddl2.serialization.mappers.PrimitiveTypeMapper;
import dev.gigaherz.util.gddl2.serialization.mappers.SetMapper;
import dev.gigaherz.util.gddl2.serialization.mappers.StringMapper;
import dev.gigaherz.util.gddl2.structure.GddlElement;
import dev.gigaherz.util.gddl2.structure.GddlMap;
import java.util.ArrayList;
import java.util.List;

public class GddlSerializer {
    public static final int PRIORITY_INTERFACE = Integer.MAX_VALUE;
    public static final int PRIORITY_USER = 0;
    public static final int PRIORITY_PRIMITIVE = -200;
    public static final int PRIORITY_COLLECTION = -300;
    private final List<Mapper> mappers = new ArrayList<Mapper>();
    private final GenericObjectMapper generic = new GenericObjectMapper(Integer.MIN_VALUE);

    public GddlSerializer() {
        this(true);
    }

    public GddlSerializer(boolean registerStockMappers) {
        if (registerStockMappers) {
            this.registerMapper(new PrimitiveTypeMapper(-200));
            this.registerMapper(new StringMapper(-200));
            this.registerMapper(new EnumMapper(-200));
            this.registerMapper(new ArrayMapper(-200));
            this.registerMapper(new ListMapper(-300));
            this.registerMapper(new MapMapper(-300));
            this.registerMapper(new SetMapper(-300));
            this.registerMapper(new PassthroughMapper(-299));
        }
    }

    public void registerMapper(Mapper mapper) {
        int prio = mapper.getPriority();
        for (int i = 0; i < this.mappers.size(); ++i) {
            Mapper existing = this.mappers.get(i);
            if (existing.getPriority() < prio) {
                this.mappers.add(i, mapper);
                return;
            }
            if (!existing.equals(mapper)) continue;
            throw new IllegalArgumentException();
        }
        this.mappers.add(mapper);
    }

    private Mapper findTopCompoundMapperForClass(Class<?> clazz) {
        for (Mapper mapper : this.mappers) {
            if (!mapper.canApply(clazz)) continue;
            return mapper;
        }
        return null;
    }

    public GddlElement<?> serialize(Object object) throws ReflectiveOperationException {
        Mapper mapper;
        if (object != null && (mapper = this.findTopCompoundMapperForClass(object.getClass())) != null) {
            return mapper.serialize(object, this);
        }
        return this.generic.serialize(object, this);
    }

    public GddlElement<?> serializeVerbose(Object object) throws ReflectiveOperationException {
        Mapper mapper;
        if (object != null && (mapper = this.findTopCompoundMapperForClass(object.getClass())) != null) {
            return mapper.serializeVerbose(object, this);
        }
        return this.generic.serializeVerbose(object, this);
    }

    public <T> T deserialize(GddlElement<?> element, Class<? extends T> clazz) throws ReflectiveOperationException {
        Mapper mapper = this.findTopCompoundMapperForClass(clazz);
        if (mapper != null) {
            return (T)mapper.deserialize(element, clazz, this);
        }
        return (T)this.generic.deserialize(element, clazz, this);
    }

    public <T> T deserializeVerbose(GddlElement<?> element) throws ReflectiveOperationException {
        if (element.isNull()) {
            return null;
        }
        GddlMap map = element.asMap();
        String className = map.getString("class");
        Class<?> clazz = Class.forName(className);
        Mapper mapper = this.findTopCompoundMapperForClass(clazz);
        if (mapper != null) {
            return (T)mapper.deserializeVerbose(map, clazz, this);
        }
        return (T)this.generic.deserializeVerbose(map, clazz, this);
    }
}

