/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.serialization.mappers;

import dev.gigaherz.util.gddl2.serialization.GddlSerializer;
import dev.gigaherz.util.gddl2.serialization.mappers.Mapper;
import dev.gigaherz.util.gddl2.structure.GddlElement;
import dev.gigaherz.util.gddl2.structure.GddlList;
import dev.gigaherz.util.gddl2.structure.GddlMap;
import java.lang.reflect.Array;
import java.util.function.ObjIntConsumer;

public class ArrayMapper
extends Mapper {
    public ArrayMapper(int priority) {
        super(priority);
    }

    @Override
    public boolean canApply(Class<?> clazz) {
        return clazz.isArray();
    }

    @Override
    public GddlElement<?> serialize(Object object, GddlSerializer serializer) throws ReflectiveOperationException {
        return this.serializeArray(object, serializer);
    }

    @Override
    public GddlElement<?> serializeVerbose(Object object, GddlSerializer serializer) throws ReflectiveOperationException {
        return this.wrapVerbose(object, this.serialize(object, serializer));
    }

    @Override
    public Object deserialize(GddlElement<?> element, Class<?> clazz, GddlSerializer serializer) throws ReflectiveOperationException {
        return this.deserializeArray(element, clazz, serializer);
    }

    @Override
    public Object deserializeVerbose(GddlMap map, Class<?> clazz, GddlSerializer serializer) throws ReflectiveOperationException {
        return this.deserialize(this.unwrapVerbose(map), clazz, serializer);
    }

    private GddlElement<?> serializeArray(Object object, GddlSerializer serializer) throws ReflectiveOperationException {
        GddlList list = GddlList.empty();
        for (int ii = 0; ii < Array.getLength(object); ++ii) {
            Object element = Array.get(object, ii);
            list.add(serializer.serialize(element));
        }
        return list;
    }

    private Object deserializeArray(GddlElement<?> map, Class<?> clazz, GddlSerializer serializer) throws ReflectiveOperationException {
        GddlList list = map.asList();
        Class<?> arrayType = clazz.getComponentType();
        Object o = Array.newInstance(arrayType, list.size());
        if (arrayType == Byte.class || arrayType == Byte.TYPE) {
            this.iterateList(list, arrayType, serializer, (value, i) -> Array.setByte(o, i, (Byte)value));
        } else if (arrayType == Short.class || arrayType == Short.TYPE) {
            this.iterateList(list, arrayType, serializer, (value, i) -> Array.setShort(o, i, (Short)value));
        } else if (arrayType == Integer.class || arrayType == Integer.TYPE) {
            this.iterateList(list, arrayType, serializer, (value, i) -> Array.setInt(o, i, (Integer)value));
        } else if (arrayType == Long.class || arrayType == Long.TYPE) {
            this.iterateList(list, arrayType, serializer, (value, i) -> Array.setLong(o, i, (Long)value));
        } else if (arrayType == Float.class || arrayType == Float.TYPE) {
            this.iterateList(list, arrayType, serializer, (value, i) -> Array.setFloat(o, i, ((Float)value).floatValue()));
        } else if (arrayType == Double.class || arrayType == Double.TYPE) {
            this.iterateList(list, arrayType, serializer, (value, i) -> Array.setDouble(o, i, (Double)value));
        } else if (arrayType == Boolean.class || arrayType == Boolean.TYPE) {
            this.iterateList(list, arrayType, serializer, (value, i) -> Array.setBoolean(o, i, (Boolean)value));
        } else if (arrayType == Character.class || arrayType == Character.TYPE) {
            this.iterateList(list, arrayType, serializer, (value, i) -> Array.setChar(o, i, ((Character)value).charValue()));
        } else {
            this.iterateList(list, arrayType, serializer, (value, i) -> Array.set(o, i, value));
        }
        return o;
    }

    private void iterateList(GddlList list, Class<?> arrayType, GddlSerializer serializer, ObjIntConsumer<Object> consumer) throws ReflectiveOperationException {
        for (int i = 0; i < list.size(); ++i) {
            Object entry = list.get(i);
            Object value = ((GddlElement)entry).isNull() ? null : (Object)serializer.deserialize((GddlElement<?>)entry, arrayType);
            consumer.accept(value, i);
        }
    }
}

