/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.serialization.mappers;

import dev.gigaherz.util.gddl2.serialization.GddlSerializer;
import dev.gigaherz.util.gddl2.serialization.mappers.Mapper;
import dev.gigaherz.util.gddl2.structure.GddlElement;
import dev.gigaherz.util.gddl2.structure.GddlMap;
import dev.gigaherz.util.gddl2.structure.GddlValue;

public class EnumMapper
extends Mapper {
    public EnumMapper(int priority) {
        super(priority);
    }

    @Override
    public boolean canApply(Class<?> clazz) {
        return clazz.isEnum();
    }

    @Override
    public GddlElement<?> serialize(Object object, GddlSerializer serializer) {
        return GddlValue.of(((Enum)object).name());
    }

    @Override
    public GddlElement<?> serializeVerbose(Object object, GddlSerializer serializer) {
        return this.wrapVerbose(object, this.serialize(object, serializer));
    }

    @Override
    public Object deserialize(GddlElement<?> element, Class<?> clazz, GddlSerializer serializer) {
        return Enum.valueOf(clazz, element.stringValue());
    }

    @Override
    public Object deserializeVerbose(GddlMap map, Class<?> clazz, GddlSerializer serializer) {
        return this.deserialize(this.unwrapVerbose(map), clazz, serializer);
    }
}

