/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.serialization.mappers;

import dev.gigaherz.util.gddl2.serialization.GddlSerializationException;
import dev.gigaherz.util.gddl2.serialization.GddlSerializer;
import dev.gigaherz.util.gddl2.serialization.mappers.Mapper;
import dev.gigaherz.util.gddl2.structure.GddlElement;
import dev.gigaherz.util.gddl2.structure.GddlList;
import dev.gigaherz.util.gddl2.structure.GddlMap;
import java.util.List;

public class ListMapper
extends Mapper {
    public ListMapper(int priority) {
        super(priority);
    }

    @Override
    public boolean canApply(Class<?> clazz) {
        return List.class.isAssignableFrom(clazz);
    }

    @Override
    public GddlElement<?> serialize(Object object, GddlSerializer serializer) throws ReflectiveOperationException {
        return this.serializeList((List)object, serializer);
    }

    @Override
    public GddlElement<?> serializeVerbose(Object object, GddlSerializer serializer) throws ReflectiveOperationException {
        return this.serialize(object, serializer);
    }

    @Override
    public Object deserialize(GddlElement<?> element, Class<?> clazz, GddlSerializer serializer) throws ReflectiveOperationException {
        return this.deserializeList(element.asMap(), clazz, serializer);
    }

    @Override
    public Object deserializeVerbose(GddlMap map, Class<?> clazz, GddlSerializer serializer) throws ReflectiveOperationException {
        return this.deserialize(map, clazz, serializer);
    }

    private GddlElement<?> serializeList(List l, GddlSerializer serializer) throws ReflectiveOperationException {
        GddlMap map = ListMapper.makeVerboseMap(l);
        GddlList list = GddlList.empty();
        for (Object entry : l) {
            list.add(serializer.serializeVerbose(entry));
        }
        map.put("elements", list);
        return map;
    }

    private List deserializeList(GddlMap map, Class<? extends List> clazz, GddlSerializer serializer) throws ReflectiveOperationException {
        Class<?> actual = Class.forName(map.getString("class"));
        if (!clazz.isAssignableFrom(actual)) {
            throw new GddlSerializationException();
        }
        List list = (List)actual.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        GddlList elements = map.getList("elements");
        for (GddlElement<?> entry : elements) {
            list.add(serializer.deserializeVerbose(entry));
        }
        return list;
    }
}

