/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.serialization.mappers;

import dev.gigaherz.util.gddl2.serialization.GddlSerializationException;
import dev.gigaherz.util.gddl2.serialization.GddlSerializer;
import dev.gigaherz.util.gddl2.serialization.mappers.Mapper;
import dev.gigaherz.util.gddl2.structure.GddlElement;
import dev.gigaherz.util.gddl2.structure.GddlList;
import dev.gigaherz.util.gddl2.structure.GddlMap;
import java.util.Map;

public class MapMapper
extends Mapper {
    public MapMapper(int priority) {
        super(priority);
    }

    @Override
    public boolean canApply(Class<?> clazz) {
        return Map.class.isAssignableFrom(clazz);
    }

    public GddlMap serialize(Object object, GddlSerializer serializer) throws ReflectiveOperationException {
        return this.serializeMap((Map)object, serializer);
    }

    @Override
    public GddlElement<?> serializeVerbose(Object object, GddlSerializer serializer) throws ReflectiveOperationException {
        return this.serialize(object, serializer);
    }

    @Override
    public Object deserialize(GddlElement<?> element, Class<?> clazz, GddlSerializer serializer) throws ReflectiveOperationException {
        return this.deserializeMap(element.asMap(), clazz, serializer);
    }

    @Override
    public Object deserializeVerbose(GddlMap map, Class<?> clazz, GddlSerializer serializer) throws ReflectiveOperationException {
        return this.deserialize(map, clazz, serializer);
    }

    private GddlMap serializeMap(Map<Object, Object> object, GddlSerializer serializer) throws ReflectiveOperationException {
        GddlMap map = MapMapper.makeVerboseMap(object);
        GddlList list = GddlList.empty();
        for (Map.Entry<Object, Object> e : object.entrySet()) {
            GddlMap entryMap = GddlMap.empty();
            Object key = e.getKey();
            Object value = e.getValue();
            entryMap.put("key", serializer.serializeVerbose(key));
            entryMap.put("value", serializer.serializeVerbose(value));
            list.add(entryMap);
        }
        map.put("elements", list);
        return map;
    }

    private Map deserializeMap(GddlMap map, Class<? extends Map> clazz, GddlSerializer serializer) throws ReflectiveOperationException {
        Class<?> actual = Class.forName(map.getString("class"));
        if (!clazz.isAssignableFrom(actual)) {
            throw new GddlSerializationException();
        }
        Map m = (Map)actual.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        GddlList elements = map.getList("elements");
        for (GddlElement<?> entry : elements) {
            GddlMap entryMap = entry.asMap();
            Object key = serializer.deserializeVerbose(entryMap.get("key"));
            Object value = serializer.deserializeVerbose(entryMap.get("value"));
            m.put(key, value);
        }
        return m;
    }
}

