/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.serialization.mappers;

import dev.gigaherz.util.gddl2.serialization.GddlSerializer;
import dev.gigaherz.util.gddl2.structure.GddlElement;
import dev.gigaherz.util.gddl2.structure.GddlMap;

public abstract class Mapper {
    private final int priority;

    public int getPriority() {
        return this.priority;
    }

    public Mapper(int priority) {
        this.priority = priority;
    }

    public abstract boolean canApply(Class<?> var1);

    protected static GddlMap makeVerboseMap(Object object) {
        GddlMap map = GddlMap.empty();
        map.put("class", object.getClass().getName());
        return map;
    }

    protected GddlMap wrapVerbose(Object object, GddlElement<?> element) {
        GddlMap map = Mapper.makeVerboseMap(object);
        map.put("value", element);
        return map;
    }

    protected GddlElement<?> unwrapVerbose(GddlMap map) {
        return map.get("value");
    }

    public abstract GddlElement<?> serialize(Object var1, GddlSerializer var2) throws ReflectiveOperationException;

    public abstract GddlElement<?> serializeVerbose(Object var1, GddlSerializer var2) throws ReflectiveOperationException;

    public abstract Object deserialize(GddlElement<?> var1, Class<?> var2, GddlSerializer var3) throws ReflectiveOperationException;

    public abstract Object deserializeVerbose(GddlMap var1, Class<?> var2, GddlSerializer var3) throws ReflectiveOperationException;
}

