/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.structure;

import dev.gigaherz.util.gddl2.formatting.Formatter;
import dev.gigaherz.util.gddl2.formatting.FormatterOptions;
import dev.gigaherz.util.gddl2.internal.Utility;
import dev.gigaherz.util.gddl2.structure.GddlElement;
import dev.gigaherz.util.gddl2.structure.GddlMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;

public final class GddlDocument {
    private final GddlElement<?> root;
    private String danglingComment;

    public static GddlDocument create() {
        return new GddlDocument();
    }

    public static GddlDocument create(GddlElement<?> root) {
        return new GddlDocument(root);
    }

    public boolean hasDanglingComment() {
        return !Utility.isNullOrEmpty(this.danglingComment);
    }

    public String getDanglingComment() {
        return this.danglingComment;
    }

    public void setDanglingComment(String danglingComment) {
        this.danglingComment = danglingComment;
    }

    public GddlElement<?> getRoot() {
        return this.root;
    }

    public void write(Path path) throws IOException {
        Files.writeString(path, (CharSequence)Formatter.format(this.root, FormatterOptions.COMPACT_HUMAN), new OpenOption[0]);
    }

    public void write(Path path, FormatterOptions formatterOptions) throws IOException {
        Files.writeString(path, (CharSequence)Formatter.format(this.root, formatterOptions), new OpenOption[0]);
    }

    private GddlDocument() {
        this(GddlMap.empty());
    }

    private GddlDocument(GddlElement<?> root) {
        this.root = root;
    }

    public String toString() {
        return Formatter.formatCompact(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.equalsImpl((GddlDocument)other);
    }

    public boolean equals(GddlDocument other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.equalsImpl(other);
    }

    private boolean equalsImpl(GddlDocument other) {
        return Objects.equals(this.root, other.root) && Objects.equals(this.danglingComment, other.danglingComment);
    }

    public int hashCode() {
        return Objects.hash(this.root, this.danglingComment);
    }
}

