/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.structure;

import dev.gigaherz.util.gddl2.exceptions.ResolutionException;
import dev.gigaherz.util.gddl2.queries.Query;
import dev.gigaherz.util.gddl2.queries.QueryComponent;
import dev.gigaherz.util.gddl2.structure.GddlElement;
import java.util.List;
import java.util.Objects;

public final class GddlReference
extends GddlElement<GddlReference> {
    private final Query path;
    private GddlElement<?> resolvedValue;

    public static GddlReference of(Query query) {
        return new GddlReference(query);
    }

    @Override
    public boolean isReference() {
        return true;
    }

    @Override
    public GddlReference asReference() {
        return this;
    }

    @Override
    public boolean isResolved() {
        return this.resolvedValue != null;
    }

    @Override
    public GddlElement<?> resolvedValue() {
        return this.resolvedValue;
    }

    public GddlReference(Query path) {
        this.path = path;
    }

    public boolean isAbsolute() {
        return this.path.isAbsolute();
    }

    public List<QueryComponent> getNameParts() {
        return this.path.pathComponents();
    }

    @Override
    protected GddlReference copyInternal() {
        GddlReference reference = new GddlReference(this.path.copy());
        this.copyTo(reference);
        return reference;
    }

    @Override
    protected void copyTo(GddlReference other) {
        super.copyTo(other);
        this.path.copyTo(other.path);
    }

    @Override
    public void resolve(GddlElement<?> root) {
        if (this.isResolved()) {
            return;
        }
        this.TryResolve(root, !this.isAbsolute());
    }

    private void TryResolve(GddlElement<?> root, boolean relative) {
        try {
            GddlElement parent = this.getParent();
            GddlElement target = relative ? (parent != null ? parent : this) : root;
            target = this.path.apply(target).findFirst().orElse(null);
            if (target != null) {
                if (!target.isResolved()) {
                    target.resolve(root);
                }
                this.resolvedValue = target.resolvedValue();
                if (this.resolvedValue != null) {
                    if (this.resolvedValue == this) {
                        throw new IllegalStateException("Invalid cyclic reference: Reference resolves to itself.");
                    }
                    while (parent != null) {
                        if (this.resolvedValue == parent) {
                            throw new IllegalStateException("Invalid cyclic reference: Reference resolves to a parent of the current element.");
                        }
                        parent = parent.getParent();
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new ResolutionException("Error resolving reference '" + String.valueOf(this) + "'", ex);
        }
    }

    @Override
    public GddlElement<?> simplify() {
        if (this.resolvedValue != null) {
            return this.resolvedValue.copy();
        }
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.equalsImpl((GddlReference)other);
    }

    @Override
    public boolean equals(GddlReference other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.equalsImpl(other);
    }

    private boolean equalsImpl(GddlReference other) {
        return super.equalsImpl(other) && Objects.equals(this.path, other.path);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.path);
    }
}

