/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.versible;

import org.jetbrains.annotations.NotNull;

public interface VersibleComponent
extends Comparable<VersibleComponent> {
    public static Numeric of(long number) {
        return new Numeric(number);
    }

    public static Alphabetic of(String word) {
        return new Alphabetic(word);
    }

    public static Suffix suffix(boolean positive) {
        return new Suffix(positive);
    }

    public record Numeric(long number) implements VersibleComponent
    {
        public Numeric {
            if (number < 0L) {
                throw new IllegalArgumentException("The number cannot be negative");
            }
        }

        @Override
        public int compareTo(@NotNull VersibleComponent o) {
            int n;
            if (o instanceof Numeric) {
                Numeric n2 = (Numeric)o;
                return Long.compare(this.number, n2.number);
            }
            if (o instanceof Suffix) {
                Suffix s = (Suffix)o;
                n = s.positive ? -1 : 1;
            } else {
                n = 1;
            }
            return n;
        }

        @Override
        public String toString() {
            return Long.toString(this.number);
        }
    }

    public record Alphabetic(String word) implements VersibleComponent
    {
        public Alphabetic {
            for (int i = 0; i < word.length(); ++i) {
                if (Character.isLetter(word.charAt(i))) continue;
                throw new IllegalArgumentException("The word must consist only of letters");
            }
        }

        @Override
        public int compareTo(@NotNull VersibleComponent o) {
            int n;
            if (o instanceof Alphabetic) {
                Alphabetic a = (Alphabetic)o;
                return this.word.compareTo(a.word);
            }
            if (o instanceof Suffix) {
                Suffix s = (Suffix)o;
                n = s.positive ? -1 : 1;
            } else {
                n = -1;
            }
            return n;
        }

        @Override
        public String toString() {
            return this.word;
        }
    }

    public record Suffix(boolean positive) implements VersibleComponent
    {
        @Override
        public int compareTo(@NotNull VersibleComponent o) {
            if (o instanceof Suffix) {
                Suffix s = (Suffix)o;
                if (s.positive == this.positive) {
                    return 0;
                }
            }
            return this.positive ? 1 : -1;
        }

        @Override
        public String toString() {
            return this.positive ? "+" : "-";
        }
    }
}

