/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.versible;

import dev.gigaherz.versible.VersibleComponent;
import dev.gigaherz.versible.VersibleRange;
import dev.gigaherz.versible.VersibleVersion;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VersibleParser {
    /*
     * Enabled aggressive block sorting
     */
    public static VersibleRange parseRange(String range) {
        int state = 0;
        VersibleVersion minVersion = null;
        VersibleVersion maxVersion = null;
        boolean minExclusive = false;
        boolean maxExclusive = false;
        int i = 0;
        while (i < range.length()) {
            char c = range.charAt(i);
            switch (state) {
                case 0: {
                    if (Character.isLetterOrDigit(c)) {
                        int[] endIndex = new int[]{0};
                        minVersion = maxVersion = VersibleParser.parseVersionInternal(range, i, range.length(), endIndex);
                        i = endIndex[0];
                        if (i >= range.length()) return new VersibleRange(minVersion, minExclusive, maxVersion, maxExclusive);
                        c = range.charAt(i);
                        if (c != '.') throw new IllegalArgumentException("Unexpected character '" + c + "' in version component.");
                        if (++i >= range.length()) {
                            throw new IllegalArgumentException("Unexpected end of string in version pattern.");
                        }
                        c = range.charAt(i);
                        if (c != '*') throw new IllegalArgumentException("Unexpected character '" + c + "' in version component.");
                        minVersion = minVersion.append(VersibleVersion.of(0));
                        maxVersion = maxVersion.bump(maxVersion.size() - 1).append(VersibleVersion.of(0));
                        maxExclusive = true;
                        if (++i >= range.length()) return new VersibleRange(minVersion, minExclusive, maxVersion, maxExclusive);
                        c = range.charAt(i);
                        throw new IllegalArgumentException("Unexpected character '" + c + "' in version component.");
                    }
                    if (c == '>') {
                        state = 1;
                        break;
                    }
                    if (c == '<') {
                        state = 2;
                        break;
                    }
                    if (c == '=') {
                        state = 3;
                        break;
                    }
                    if (c == '(') {
                        state = 6;
                        minExclusive = true;
                        break;
                    }
                    if (c != '[') throw new IllegalArgumentException("Unexpected character '" + c + "' in version range.");
                    state = 6;
                    break;
                }
                case 1: 
                case 2: {
                    if (c == '=') {
                        state += 3;
                        break;
                    }
                }
                case 3: 
                case 4: 
                case 5: {
                    if (!Character.isLetterOrDigit(c)) throw new IllegalArgumentException("Unexpected character '" + c + "' in version range.");
                    int[] endIndex = new int[]{0};
                    VersibleVersion v = VersibleParser.parseVersionInternal(range, i, range.length(), endIndex);
                    i = endIndex[0];
                    if (i < range.length()) {
                        c = range.charAt(i);
                        throw new IllegalArgumentException("Unexpected character '" + c + "' in version component.");
                    }
                    switch (state) {
                        case 1: {
                            minVersion = v;
                            minExclusive = true;
                            return new VersibleRange(minVersion, minExclusive, maxVersion, maxExclusive);
                        }
                        case 2: {
                            maxVersion = v;
                            maxExclusive = true;
                            return new VersibleRange(minVersion, minExclusive, maxVersion, maxExclusive);
                        }
                        case 3: {
                            minVersion = maxVersion = v;
                            return new VersibleRange(minVersion, minExclusive, maxVersion, maxExclusive);
                        }
                        case 4: {
                            minVersion = v;
                            return new VersibleRange(minVersion, minExclusive, maxVersion, maxExclusive);
                        }
                        case 5: {
                            maxVersion = v;
                            return new VersibleRange(minVersion, minExclusive, maxVersion, maxExclusive);
                        }
                    }
                    return new VersibleRange(minVersion, minExclusive, maxVersion, maxExclusive);
                }
                case 6: {
                    if (Character.isLetterOrDigit(c)) {
                        int[] endIndex = new int[]{0};
                        minVersion = VersibleParser.parseVersionInternal(range, i, range.length(), endIndex);
                        i = endIndex[0];
                        if (i >= range.length()) {
                            throw new IllegalArgumentException("Unexpected end of string in version interval.");
                        }
                        c = range.charAt(i);
                        if (c == ',') {
                            if (++i >= range.length()) {
                                throw new IllegalArgumentException("Unexpected end of string in version interval.");
                            }
                            c = range.charAt(i);
                            if (Character.isLetterOrDigit(c)) {
                                maxVersion = VersibleParser.parseVersionInternal(range, i, range.length(), endIndex);
                                i = endIndex[0];
                                if (i >= range.length()) {
                                    throw new IllegalArgumentException("Unexpected end of string in version interval.");
                                }
                                c = range.charAt(i);
                            }
                        } else {
                            maxVersion = minVersion;
                        }
                        if (c == ')') {
                            maxExclusive = true;
                        } else if (c != ']') {
                            throw new IllegalArgumentException("Unexpected character '" + c + "' in version interval.");
                        }
                        if (++i >= range.length()) return new VersibleRange(minVersion, minExclusive, maxVersion, maxExclusive);
                        c = range.charAt(i);
                        throw new IllegalArgumentException("Unexpected character '" + c + "' after version interval.");
                    }
                    if (c != ',') throw new IllegalArgumentException("Unexpected character '" + c + "' in version interval.");
                    int[] endIndex = new int[]{0};
                    maxVersion = VersibleParser.parseVersionInternal(range, i + 1, range.length(), endIndex);
                    i = endIndex[0];
                    if (i >= range.length()) {
                        throw new IllegalArgumentException("Unexpected end of string in version interval.");
                    }
                    c = range.charAt(i);
                    if (c == ')') {
                        maxExclusive = true;
                    } else if (c != ']') {
                        throw new IllegalArgumentException("Unexpected character '" + c + "' in version interval.");
                    }
                    if (++i >= range.length()) return new VersibleRange(minVersion, minExclusive, maxVersion, maxExclusive);
                    c = range.charAt(i);
                    throw new IllegalArgumentException("Unexpected character '" + c + "' after version interval.");
                }
            }
            ++i;
        }
        return new VersibleRange(minVersion, minExclusive, maxVersion, maxExclusive);
    }

    @NotNull
    public static VersibleVersion parseVersion(String version) {
        return VersibleParser.parseVersionInternal(version, 0, version.length(), null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static VersibleVersion parseVersionInternal(@NotNull CharSequence version, int start, int end, int @Nullable [] outIndex) {
        int i;
        ArrayList<Record> components = new ArrayList<Record>();
        int state = 0;
        int wordStart = start;
        int lastGood = 0;
        block9: for (i = start; i < end; ++i) {
            char c = version.charAt(i);
            switch (state) {
                case 0: {
                    if (Character.isDigit(c)) {
                        state = 1;
                        wordStart = i;
                        lastGood = i + 1;
                        break;
                    }
                    if (Character.isLetter(c)) {
                        state = 2;
                        wordStart = i;
                        lastGood = i + 1;
                        break;
                    }
                    if (outIndex == null) {
                        throw new IllegalArgumentException("Unexpected character '" + c + "' at the start of a version component.");
                    }
                    outIndex[0] = lastGood;
                    break block9;
                }
                case 1: {
                    if (Character.isDigit(c)) {
                        lastGood = i + 1;
                        break;
                    }
                    long number = Long.parseUnsignedLong(version, wordStart, i, 10);
                    components.add(VersibleComponent.of(number));
                    if (Character.isLetter(c)) {
                        state = 2;
                        wordStart = i;
                        break;
                    }
                    if (c == '.') {
                        state = 0;
                        break;
                    }
                    if (c == '-') {
                        components.add(VersibleComponent.suffix(false));
                        state = 0;
                        break;
                    }
                    if (c == '+') {
                        components.add(VersibleComponent.suffix(true));
                        state = 0;
                        break;
                    }
                    state = 0;
                    if (outIndex == null) {
                        throw new IllegalArgumentException("Unexpected character '" + c + "' in version component.");
                    }
                    outIndex[0] = lastGood;
                    break block9;
                }
                case 2: {
                    if (Character.isLetter(c)) {
                        lastGood = i + 1;
                        break;
                    }
                    String word = version.subSequence(wordStart, i).toString();
                    components.add(VersibleComponent.of(word));
                    if (Character.isDigit(c)) {
                        state = 1;
                        wordStart = i;
                        break;
                    }
                    if (c == '.') {
                        state = 0;
                        break;
                    }
                    if (c == '-') {
                        components.add(VersibleComponent.suffix(false));
                        state = 0;
                        break;
                    }
                    if (c == '+') {
                        components.add(VersibleComponent.suffix(true));
                        state = 0;
                        break;
                    }
                    state = 0;
                    if (outIndex == null) {
                        throw new IllegalArgumentException("Unexpected character '" + c + "' in version component.");
                    }
                    outIndex[0] = lastGood;
                    break block9;
                }
            }
        }
        switch (state) {
            case 1: {
                long number = Long.parseUnsignedLong(version, wordStart, i, 10);
                components.add(VersibleComponent.of(number));
                break;
            }
            case 2: {
                String word = version.subSequence(wordStart, i).toString();
                components.add(VersibleComponent.of(word));
                break;
            }
        }
        if (components.size() == 0) {
            throw new IllegalArgumentException("Version string cannot be empty.");
        }
        if (outIndex != null) {
            outIndex[0] = lastGood;
        }
        return new VersibleVersion(Collections.unmodifiableList(components));
    }

    private VersibleParser() {
        throw new IllegalArgumentException("This class cannot be instantiated.");
    }
}

