/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.versible;

import dev.gigaherz.versible.VersibleVersion;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public record VersibleRange(@Nullable VersibleVersion minVersion, boolean minExclusive, @Nullable VersibleVersion maxVersion, boolean maxExclusive) implements Predicate<VersibleVersion>
{
    @Contract(value="null, _, null, _ -> fail")
    @ApiStatus.Internal
    public VersibleRange(@Nullable VersibleVersion minVersion, boolean minExclusive, @Nullable VersibleVersion maxVersion, boolean maxExclusive) {
        if (minVersion == null && maxVersion == null) {
            throw new IllegalArgumentException("Cannot construct a range with no ends. Either minVersion or maxVersion must be non-null");
        }
    }

    public static VersibleRange between(VersibleVersion min, VersibleVersion max) {
        return new VersibleRange(min, false, max, false);
    }

    public static VersibleRange betweenOpen(VersibleVersion min, VersibleVersion max) {
        return new VersibleRange(min, true, max, true);
    }

    public static VersibleRange betweenClosedOpen(VersibleVersion min, VersibleVersion max) {
        return new VersibleRange(min, false, max, true);
    }

    public static VersibleRange betweenOpenClosed(VersibleVersion min, VersibleVersion max) {
        return new VersibleRange(min, true, max, false);
    }

    public static VersibleRange atLeast(VersibleVersion min) {
        return new VersibleRange(min, false, null, true);
    }

    public static VersibleRange moreThan(VersibleVersion min) {
        return new VersibleRange(min, true, null, true);
    }

    public static VersibleRange atMost(VersibleVersion max) {
        return new VersibleRange(null, true, max, false);
    }

    public static VersibleRange lessThan(VersibleVersion max) {
        return new VersibleRange(null, true, max, true);
    }

    public static VersibleRange exactly(VersibleVersion version) {
        return new VersibleRange(version, false, version, false);
    }

    public boolean contains(VersibleVersion version) {
        int maxComparison;
        int minComparison;
        if (this.minVersion != null && ((minComparison = this.minVersion.compareTo(version)) > 0 || this.minExclusive && minComparison == 0)) {
            return false;
        }
        return this.maxVersion == null || (maxComparison = this.maxVersion.compareTo(version)) >= 0 && (!this.maxExclusive || maxComparison != 0);
    }

    @Override
    public boolean test(VersibleVersion version) {
        return this.contains(version);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersibleRange that = (VersibleRange)o;
        return !(!Objects.equals(this.minVersion, that.minVersion) || !Objects.equals(this.maxVersion, that.maxVersion) || this.minVersion != null && this.minExclusive != that.minExclusive || this.maxVersion != null && this.maxExclusive != that.maxExclusive);
    }

    @Override
    public int hashCode() {
        int hash = 0;
        if (this.minVersion != null) {
            hash = hash * 31 + Objects.hash(this.minVersion, this.minExclusive);
        }
        if (this.minVersion != null) {
            hash = hash * 31 + Objects.hash(this.maxVersion, this.maxExclusive);
        }
        return hash;
    }

    @Override
    public String toString() {
        if (this.minVersion != null && this.maxVersion != null) {
            String open = this.minExclusive ? "(" : "[";
            String close = this.minExclusive ? ")" : "]";
            return open + this.minVersion + "," + this.maxVersion + close;
        }
        if (this.minVersion != null) {
            String open = this.minExclusive ? "(" : "[";
            return open + this.minVersion + ",)";
        }
        if (this.maxVersion != null) {
            String close = this.minExclusive ? ")" : "]";
            return "(," + this.maxVersion + close;
        }
        return "(invalid)";
    }
}

