/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.versible;

import dev.gigaherz.versible.VersibleComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public record VersibleVersion(@NotNull List<VersibleComponent> components) implements Comparable<VersibleVersion>
{
    @ApiStatus.Internal
    public VersibleVersion(@NotNull List<VersibleComponent> components) {
        if (components.isEmpty()) {
            throw new IllegalArgumentException("The component list cannot be empty.");
        }
    }

    public static VersibleVersion of(Object ... components) {
        ArrayList<Object> componentList = new ArrayList<Object>();
        for (Object obj : components) {
            if (obj instanceof Number) {
                Number n = (Number)obj;
                componentList.add(VersibleComponent.of(n.longValue()));
                continue;
            }
            if (obj instanceof String) {
                String s = (String)obj;
                if (s.equals("+")) {
                    componentList.add(VersibleComponent.suffix(true));
                    continue;
                }
                if (s.equals("-")) {
                    componentList.add(VersibleComponent.suffix(false));
                    continue;
                }
                componentList.add(VersibleComponent.of(s));
                continue;
            }
            if (obj instanceof Character) {
                Character c = (Character)obj;
                if (c.charValue() == '+') {
                    componentList.add(VersibleComponent.suffix(true));
                    continue;
                }
                if (c.charValue() == '-') {
                    componentList.add(VersibleComponent.suffix(false));
                    continue;
                }
                componentList.add(VersibleComponent.of(c.toString()));
                continue;
            }
            if (obj instanceof VersibleVersion) {
                VersibleVersion v = (VersibleVersion)obj;
                componentList.addAll(v.components);
                continue;
            }
            throw new IllegalArgumentException("Cannot construct version component from " + obj.getClass().getName());
        }
        return new VersibleVersion(Collections.unmodifiableList(componentList));
    }

    public int size() {
        return this.components.size();
    }

    public VersibleComponent get(int index) {
        return this.components.get(index);
    }

    public Stream<VersibleComponent> stream() {
        return this.components.stream();
    }

    @Override
    public int compareTo(VersibleVersion o) {
        VersibleComponent.Suffix s;
        VersibleComponent versibleComponent;
        int i;
        int min = Math.min(this.size(), o.size());
        for (i = 0; i < min; ++i) {
            VersibleComponent b;
            VersibleComponent a = this.get(i);
            int c = a.compareTo(b = o.get(i));
            if (c == 0) continue;
            return c;
        }
        if (this.size() > o.size()) {
            versibleComponent = this.get(i);
            return versibleComponent instanceof VersibleComponent.Suffix && !(s = (VersibleComponent.Suffix)versibleComponent).positive() ? -1 : 1;
        }
        if (this.size() < o.size()) {
            versibleComponent = o.get(i);
            return versibleComponent instanceof VersibleComponent.Suffix && !(s = (VersibleComponent.Suffix)versibleComponent).positive() ? 1 : -1;
        }
        return 0;
    }

    public VersibleVersion append(VersibleVersion other) {
        ArrayList<VersibleComponent> mergedComponents = new ArrayList<VersibleComponent>();
        mergedComponents.addAll(this.components);
        mergedComponents.addAll(other.components);
        return new VersibleVersion(Collections.unmodifiableList(mergedComponents));
    }

    public VersibleVersion bump(int index) {
        ArrayList<VersibleComponent> newList = new ArrayList<VersibleComponent>(this.components);
        VersibleComponent component = (VersibleComponent)newList.get(index);
        if (!(component instanceof VersibleComponent.Numeric)) {
            throw new IllegalArgumentException("The component at index " + index + " is not a numeric component.");
        }
        VersibleComponent.Numeric num = (VersibleComponent.Numeric)component;
        newList.set(index, VersibleComponent.of(num.number() + 1L));
        return new VersibleVersion(Collections.unmodifiableList(newList));
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        boolean lastWasNumber = false;
        boolean lastWasWord = false;
        for (VersibleComponent component : this.components) {
            if (component instanceof VersibleComponent.Numeric) {
                VersibleComponent.Numeric n = (VersibleComponent.Numeric)component;
                if (lastWasNumber) {
                    b.append('.');
                }
                b.append(n);
                lastWasNumber = true;
                lastWasWord = false;
                continue;
            }
            if (component instanceof VersibleComponent.Alphabetic) {
                VersibleComponent.Alphabetic a = (VersibleComponent.Alphabetic)component;
                if (lastWasWord) {
                    b.append('.');
                }
                b.append(a);
                lastWasNumber = false;
                lastWasWord = true;
                continue;
            }
            if (!(component instanceof VersibleComponent.Suffix)) continue;
            VersibleComponent.Suffix s = (VersibleComponent.Suffix)component;
            b.append(s);
            lastWasNumber = false;
            lastWasWord = false;
        }
        return b.toString();
    }
}

