/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.capabilities.api.energy.compat;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import gigaherz.capabilities.api.energy.IEnergyHandler;
import net.minecraft.util.EnumFacing;

public class RFWrapper
implements IEnergyHandler {
    IEnergyReceiver recv;
    IEnergyProvider prov;
    EnumFacing side;

    public static RFWrapper wrap(Object obj, EnumFacing side) {
        IEnergyReceiver recv = null;
        IEnergyProvider prov = null;
        if (obj instanceof IEnergyReceiver && !(recv = (IEnergyReceiver)obj).canConnectEnergy(side)) {
            recv = null;
        }
        if (obj instanceof IEnergyProvider && !(prov = (IEnergyProvider)obj).canConnectEnergy(side)) {
            prov = null;
        }
        if (recv != null || prov != null) {
            return new RFWrapper(recv, prov, side);
        }
        return null;
    }

    public RFWrapper(IEnergyReceiver recv, IEnergyProvider prov, EnumFacing side) {
        this.side = side;
        this.recv = recv;
        this.prov = prov;
    }

    @Override
    public int getCapacity() {
        return this.recv != null ? this.recv.getMaxEnergyStored(this.side) : (this.prov != null ? this.prov.getMaxEnergyStored(this.side) : 0);
    }

    @Override
    public int getEnergy() {
        return this.recv != null ? this.recv.getEnergyStored(this.side) : (this.prov != null ? this.prov.getEnergyStored(this.side) : 0);
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.prov != null ? this.prov.extractEnergy(this.side, maxExtract, simulate) : 0;
    }

    @Override
    public int insertEnergy(int maxReceive, boolean simulate) {
        return this.recv != null ? this.recv.receiveEnergy(this.side, maxReceive, simulate) : 0;
    }
}

